% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{drawIsopycnals}
\alias{drawIsopycnals}
\title{Add Isopycnal Curves to TS Plot}
\usage{
drawIsopycnals(
  nlevels = 6,
  levels,
  rotate = TRUE,
  rho1000 = FALSE,
  digits = 2,
  eos = getOption("oceEOS", default = "gsw"),
  cex = 0.75 * par("cex"),
  col = "darkgray",
  lwd = par("lwd"),
  lty = par("lty")
)
}
\arguments{
\item{nlevels}{suggested number of density levels (i.e. isopycnal curves);
ignored if \code{levels} is supplied.}

\item{levels}{optional density levels to draw.}

\item{rotate}{boolean, set to \code{TRUE} to write all density labels
horizontally.}

\item{rho1000}{boolean, set to \code{TRUE} to write isopycnal labels as e.g.
1024 instead of 24.}

\item{digits}{number of decimal digits to use in label (supplied to
\code{\link[=round]{round()}}).}

\item{eos}{equation of state to be used, either \code{"unesco"} or
\code{"gsw"}.}

\item{cex}{size for labels.}

\item{col}{color for lines and labels.}

\item{lwd}{line width for isopycnal curves}

\item{lty}{line type for isopycnal curves}
}
\value{
None.
}
\description{
Adds isopycnal lines to an existing temperature-salinity plot.  This is
called by \code{\link[=plotTS]{plotTS()}}, and may be called by the user also, e.g. if
an image plot is used to show TS data density.
}
\seealso{
\code{\link[=plotTS]{plotTS()}}, which calls this.
}
\author{
Dan Kelley
}
