% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lobo.R
\name{read.lobo}
\alias{read.lobo}
\title{Read a LOBO File}
\usage{
read.lobo(file, cols = 7, processingLog)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file
to load.}

\item{cols}{number of columns in dataset.}

\item{processingLog}{if provided, the action item to be stored in the log.
(Typically only provided for internal calls; the default that it provides is
better for normal calls by a user.)}
}
\value{
An object of \code{\link{lobo-class}}.
}
\description{
Read a data file created by a LOBO instrument.
}
\details{
This version of \code{read.lobo} is really quite crude, having been
developed mainly for a ``predict the Spring bloom'' contest at Dalhousie
University.  In particular, the function assumes that the data columns are
exactly as specified in the Examples section; if you reorder the columns or
add new ones, this function is unlikely to work correctly. Furthermore, it
should be noted that the file format was inferred simply by downloading
files; the supplier makes no claims that the format will be fixed in time.
It is also worth noting that there is no \code{\link{read.oce}} equivalent
to \code{read.lobo}, because the file format has no recognizable header.
}
\examples{
\dontrun{
library(oce)
uri <- paste("http://lobo.satlantic.com/cgi-bin/nph-data.cgi?",
  "min_date=20070220&max_date=20070305",
  "&x=date&",
  "y=current_across1,current_along1,nitrate,fluorescence,salinity,temperature&",
  "data_format=text",sep="")
lobo <- read.lobo(uri)
}
}
\seealso{
Other things related to lobo data: \code{\link{[[,lobo-method}},
  \code{\link{[[<-,lobo-method}}, \code{\link{as.lobo}},
  \code{\link{lobo-class}}, \code{\link{lobo}},
  \code{\link{plot,lobo-method}},
  \code{\link{subset,lobo-method}},
  \code{\link{summary,lobo-method}}
}
\author{
Dan Kelley
}
\concept{things related to lobo data}
