% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ad.R
\name{beamToXyz}
\alias{beamToXyz}
\title{Change ADV or ADP coordinate systems}
\usage{
beamToXyz(x, ...)
}
\arguments{
\item{x}{an \code{adp} or \code{adv} object, i.e. one inheriting from
\code{\link{adp-class}} or \code{\link{adv-class}}.}

\item{\dots}{extra arguments that are passed on to \code{\link{beamToXyzAdp}}
or \code{\link{beamToXyzAdv}}.}
}
\value{
An object of the same type as \code{x}, but with velocities
in xyz coordinates instead of beam coordinates.
}
\description{
Convert velocity data from an acoustic-Doppler velocimeter or
acoustic-Doppler profiler from one coordinate system to another.
}
\seealso{
Other things related to \code{adp} data: \code{\link{[[,adp-method}},
  \code{\link{[[<-,adp-method}}, \code{\link{adp-class}},
  \code{\link{adpEnsembleAverage}}, \code{\link{adp}},
  \code{\link{as.adp}}, \code{\link{beamName}},
  \code{\link{beamToXyzAdp}}, \code{\link{beamToXyzAdv}},
  \code{\link{beamUnspreadAdp}}, \code{\link{binmapAdp}},
  \code{\link{enuToOtherAdp}}, \code{\link{enuToOther}},
  \code{\link{plot,adp-method}},
  \code{\link{read.adp.nortek}},
  \code{\link{read.adp.rdi}},
  \code{\link{read.adp.sontek.serial}},
  \code{\link{read.adp.sontek}}, \code{\link{read.adp}},
  \code{\link{read.aquadoppHR}},
  \code{\link{read.aquadoppProfiler}},
  \code{\link{read.aquadopp}},
  \code{\link{subset,adp-method}},
  \code{\link{summary,adp-method}}, \code{\link{toEnuAdp}},
  \code{\link{toEnu}}, \code{\link{velocityStatistics}},
  \code{\link{xyzToEnuAdp}}, \code{\link{xyzToEnu}}

Other things related to \code{adv} data: \code{\link{[[,adv-method}},
  \code{\link{[[<-,adv-method}}, \code{\link{adv-class}},
  \code{\link{adv}}, \code{\link{beamName}},
  \code{\link{enuToOtherAdv}}, \code{\link{enuToOther}},
  \code{\link{plot,adv-method}},
  \code{\link{read.adv.nortek}},
  \code{\link{read.adv.sontek.adr}},
  \code{\link{read.adv.sontek.serial}},
  \code{\link{read.adv.sontek.text}},
  \code{\link{read.adv}}, \code{\link{subset,adv-method}},
  \code{\link{summary,adv-method}}, \code{\link{toEnuAdv}},
  \code{\link{toEnu}}, \code{\link{velocityStatistics}},
  \code{\link{xyzToEnuAdv}}, \code{\link{xyzToEnu}}
}
\author{
Dan Kelley
}
