% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argo.R
\docType{class}
\name{argo-class}
\alias{argo-class}
\title{Class to hold Argo data}
\description{
This class stores data from argo floats. It will be in fairly
active development in the early months of 2016.
}
\details{
An \code{argo} object may be read with \code{\link{read.argo}} or
created with \code{\link{as.argo}}.  Argo data can be gridded to constant
pressures with \code{\link{argoGrid}}.  Plots can be made with
\code{\link{plot,argo-method}}, while \code{\link{summary,argo-method}} produces statistical
summaries and \code{show} produces overviews. The usual oce generic
functions are available, e.g. \code{\link{[[,argo-method}} may 
be used to extract data, and \code{\link{[[<-,argo-method}} may
be used to insert data.

See \url{http://www.argo.ucsd.edu/Gridded_fields.html} for some
argo-related datasets that may be useful in a wider context.
}
\author{
Dan Kelley and Clark Richards
}
\seealso{
Other classes provided by \code{oce}: \code{\link{adp-class}},
  \code{\link{adv-class}}, \code{\link{bremen-class}},
  \code{\link{cm-class}}, \code{\link{coastline-class}},
  \code{\link{ctd-class}}, \code{\link{echosounder-class}},
  \code{\link{lisst-class}}, \code{\link{lobo-class}},
  \code{\link{met-class}}, \code{\link{oce-class}},
  \code{\link{odf-class}}, \code{\link{rsk-class}},
  \code{\link{sealevel-class}},
  \code{\link{section-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}

Other things related to \code{argo} data: \code{\link{[[,argo-method}},
  \code{\link{[[<-,argo-method}}, \code{\link{argoGrid}},
  \code{\link{argo}}, \code{\link{as.argo}},
  \code{\link{handleFlags,argo-method}},
  \code{\link{plot,argo-method}}, \code{\link{read.argo}},
  \code{\link{subset,argo-method}},
  \code{\link{summary,argo-method}}
}

