% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topo.R
\docType{data}
\name{topoWorld}
\alias{topoWorld}
\title{Global Topographic Dataset at Half-degree Resolution}
\source{
The binary ETOPO5 dataset was downloaded in late 2009 from the NOAA website,
\samp{http://www.ngdc.noaa.gov/mgg/global/relief/ETOPO5/TOPO/ETOPO5} (link last checked 2016-06-12),
decoded, decimated from 1/12th degree resolution to 1/2 degree resolution, and
passed through \code{\link{matrixShiftLongitude}} so that longitude is
between -180 and 180 degrees.
}
\usage{
data(topoWorld)
}
\description{
Global topographic dataset at half-degree resolution, created by decimating the
ETOPO5 dataset.  Its longitude ranges from -179.5 to 180, and its latitude
ranges from -89.5 to 90.  Height is measured in metres above nominal sea level.

The coarse resolution can be a problem in plotting depth contours along with
coastlines in regions of steep topography. For example, near the southeast
corner of Newfoundland, a 200m contour will overlap a coastline drawn with
\code{\link[ocedata]{coastlineWorldFine}}. The solution in such cases is to
download a higher-resolution topography file and create a \code{topo} object
with \code{\link{read.topo}} or \code{\link{as.topo}}.
}
\examples{
\dontrun{
library(oce)
data(topoWorld) 
par(mfrow=c(2,1))
plot(topoWorld, location=NULL)
imagep(topoWorld)
}

}
\seealso{
Other datasets provided with \code{oce}: \code{\link{adp}},
  \code{\link{adv}}, \code{\link{argo}}, \code{\link{cm}},
  \code{\link{coastlineWorld}}, \code{\link{colors}},
  \code{\link{ctdRaw}}, \code{\link{ctd}},
  \code{\link{echosounder}}, \code{\link{landsat}},
  \code{\link{lisst}}, \code{\link{lobo}},
  \code{\link{met}}, \code{\link{rsk}},
  \code{\link{sealevelTuktoyaktuk}},
  \code{\link{sealevel}}, \code{\link{section}},
  \code{\link{wind}}

Other things related to \code{topo} data: \code{\link{[[,topo-method}},
  \code{\link{[[<-,topo-method}}, \code{\link{as.topo}},
  \code{\link{plot,topo-method}}, \code{\link{read.topo}},
  \code{\link{subset,topo-method}},
  \code{\link{summary,topo-method}},
  \code{\link{topo-class}}, \code{\link{topoInterpolate}}
}

