% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapPoints}
\alias{mapPoints}
\title{Add Points to a Map}
\usage{
mapPoints(longitude, latitude, debug = getOption("oceDebug"), ...)
}
\arguments{
\item{longitude}{Longitudes of points to be plotted, or an object from which
longitude and latitude can be inferred in which case the following two
arguments are ignored.  This objects that are possible include those of type
\code{coastline}.}

\item{latitude}{Latitudes of points to be plotted.}

\item{debug}{A flag that turns on debugging.  Set to 1 to get a moderate amount
of debugging information, or to 2 to get more.}

\item{...}{Optional arguments passed to \code{\link{points}}.}
}
\description{
Plot points on an existing map.
}
\details{
Adds points to an existing map, by analogy to \code{\link{points}}.
}
\examples{
\dontrun{
    library(oce)
    data(coastlineWorld)
    mapPlot(coastlineWorld, type='l', grid=TRUE,
    longitudelim=c(-80,0), latitudelim=c(20,50),
    projection="+proj=merc", orientation=c(90,0,0))
    data(section)
    mapPoints(section)
}

}
\author{
Dan Kelley
}
\seealso{
A map must first have been created with \code{\link{mapPlot}}.

A map must first have been created with \code{\link{mapPlot}}.

Other functions related to maps: \code{\link{lonlat2map}},
  \code{\link{lonlat2utm}}, \code{\link{map2lonlat}},
  \code{\link{mapArrows}}, \code{\link{mapAxis}},
  \code{\link{mapContour}},
  \code{\link{mapDirectionField}}, \code{\link{mapGrid}},
  \code{\link{mapImage}}, \code{\link{mapLines}},
  \code{\link{mapLocator}},
  \code{\link{mapLongitudeLatitudeXY}},
  \code{\link{mapMeridians}}, \code{\link{mapPlot}},
  \code{\link{mapPolygon}}, \code{\link{mapScalebar}},
  \code{\link{mapText}}, \code{\link{mapTissot}},
  \code{\link{mapZones}}, \code{\link{shiftLongitude}},
  \code{\link{utm2lonlat}}
}

