% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satellite.R
\docType{methods}
\name{plot,satellite-method}
\alias{plot,satellite-method}
\alias{plot.satellite}
\title{Plot a satellite object}
\usage{
\S4method{plot}{satellite}(x, y, asp, debug = getOption("oceDebug"), ...)
}
\arguments{
\item{x}{An object inherting from \code{\link{satellite-class}}.}

\item{y}{String indicating the quantity to be plotted.}

\item{asp}{Optional aspect ratio for plot.}

\item{debug}{A debugging flag, integer.}

\item{...}{extra arguments passed to \code{\link{imagep}}, e.g. set
\code{col} to control colours.}
}
\description{
For an example using \code{g1sst} data, see \code{\link{read.g1sst}}.
}
\author{
Dan Kelley
}
\seealso{
Other functions dealing with satellite data: \code{\link{[[,landsat-method}},
  \code{\link{amsr-class}}, \code{\link{g1sst-class}},
  \code{\link{landsatAdd}}, \code{\link{landsatTrim}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,landsat-method}},
  \code{\link{read.amsr}}, \code{\link{read.g1sst}},
  \code{\link{read.landsat}},
  \code{\link{satellite-class}},
  \code{\link{summary,amsr-method}},
  \code{\link{summary,landsat-method}},
  \code{\link{summary,satellite-method}}
}
\concept{
satellite
}

