\name{sw.viscosity}

\alias{sw.viscosity}

\title{Seawater viscosity}

\description{Compute viscosity of seawater, in \eqn{Pa\cdot s}{Pa*s}}

\usage{sw.viscosity(S, t=NULL)}

\arguments{
  \item{S}{either salinity [PSU] (in which case \code{t} and \code{p}
    must be provided) \strong{or} a \code{ctd} object (in which case
    \code{S}, \code{t} and \code{p} are determined from the object, and
    must not be provided in the argument list).}
  \item{t}{\emph{in-situ} temperature [\eqn{^\circ}{deg}C]}
}

\details{If the first argument is a \code{ctd} object, then salinity,
  temperature and pressure values are extracted from it, and used for
  the calculation.

  The result is determined from a regression of the data provided in
  Table 87 of Dorsey (1940). The fit matches the table to within 0.2
  percent at worst, and with average absolute error of 0.07 percent. The
  maximum deviation from the table is one unit in the last decimal
  place.

  No pressure dependence was reported by Dorsey (1940).
}

\value{Viscosity of seawater in \eqn{Pa\cdot s}{Pa*s}.  Divide by density to get kinematic viscosity in \eqn{m^2/s}{m^2/s}.}
\examples{
 v <- sw.viscosity(30,10); # 0.001383779
}

\references{N. Ernest Dorsey (1940), \emph{Properties of ordinary
 Water-substance}, American Chemical Society Monograph Series.  Reinhold
 Publishing.}

\author{Dan Kelley}

\keyword{misc}
