% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parent.R
\name{parent}
\alias{parent}
\alias{parent.rtree}
\alias{has.parent}
\title{Parent of a node}
\usage{
parent(.node, .tree, degree = 1L)

\method{parent}{rtree}(.node, .tree, degree = 1L)

has.parent(.node, .tree)
}
\arguments{
\item{.node}{node or character. The node or node label considered.}

\item{.tree}{A tree.}

\item{degree}{integer. Currently not used.}
}
\value{
A node.
}
\description{
The function \code{parent} returns the parent 
of a node in a given tree. 
If the node is not found in the tree or has no parent, 
the empty tree is returned.
}
\examples{
## Rooted tree
(tr0 = c_("Bob", "Carl", "Daniel"))
(tr1 = c_("Bill", "Caroline", "Dimitri", "Enoc"))
(tr2 = r_("Alice", s = list(tr0, tr1)))

## Unrooted tree
(tr3 = r_(s = list(tr2, c_("Son", "Father", "Grand-Mother"))))
parent("Alice", tr3)
parent("Bob", tr3)
parent("any node", tr3)

}
