% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMediaUrl.R
\name{getMediaUrl}
\alias{getMediaUrl}
\title{Gets the URL of the given media track for a given transcript.}
\usage{
getMediaUrl(labbcat.url, id, track.suffix = "", mime.type = "audio/wav")
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance.}

\item{id}{A transcript ID (i.e. transcript name).}

\item{track.suffix}{The track suffix of the media.}

\item{mime.type}{The MIME type of the media, e.g. "audio/wav" or "application/f0".}
}
\value{
A URL to the given media for the given transcript.
}
\description{
Gets the URL of the given media track for a given transcript.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get URL for the WAV file for BR2044_OllyOhlson.eaf
wavUrl <- getMediaUrl(labbcat.url, "BR2044_OllyOhlson.eaf")

## Get URL for the 'QuakeFace' video file for BR2044_OllyOhlson.eaf
quakeFaceMp4Url <- getMediaUrl(labbcat.url, "BR2044_OllyOhlson.eaf", "_face", "video/mp4")
}

}
\seealso{
\link{getTranscriptIds}

\link{getMedia}
}
\keyword{audio}
\keyword{media}
