% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{get_food}
\alias{get_food}
\title{get_food}
\usage{
get_food(apiKey = NULL, foodCode = NULL, lang = "en")
}
\arguments{
\item{apiKey}{Key to access the API. Can be retrieved from
\url{https://hc-sc.api.canada.ca/en/detail?api=cnf#!/Nutrient/get_nutrientamount}.
If none is provided, the system environment variables will be checked.}

\item{foodCode}{The code indicating the food you want to search for. If null,
all foods are returned.}

\item{lang}{The language to return results in, can be either 'en' or 'fr'.}
}
\value{
A tibble containing food names and food ids.
}
\description{
Makes a query to the Canadian Nutrient File food endpoint. This endpoint returns
data from a list of food codes and corresponding names.
}
\examples{
\dontrun{
get_food()
get_food(foodCode = 2314)
get_food(foodcode = 2314, lang = "fr")
}
}
