% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_quarter.R
\name{f_quarter}
\alias{f_quarter}
\alias{f_quarter.default}
\alias{f_quarter.numeric}
\alias{f_quarter.Date}
\alias{f_quarter.POSIXt}
\alias{f_quarter.hms}
\alias{ff_quarter}
\title{Format Quarters}
\usage{
f_quarter(x, prefix = "Q", space = "", max = 12, ...)

\method{f_quarter}{default}(x, prefix = "Q", space = "", max = 12, ...)

\method{f_quarter}{numeric}(x, prefix = "Q", space = "",
  max = ifelse(all(x \%in\% c(1:4, NA)), 4, 12), ...)

\method{f_quarter}{Date}(x, prefix = "Q", space = "", max = 12, ...)

\method{f_quarter}{POSIXt}(x, prefix = "Q", space = "", max = 12, ...)

\method{f_quarter}{hms}(x, prefix = "Q", space = "", max = 12, ...)

ff_quarter(prefix = "Q", space = "", max = 12, ...)
}
\arguments{
\item{x}{A vector of month names, integers 1-12, or dates.}

\item{prefix}{A quarter prefix (defaults to \code{'Q'}).}

\item{space}{A string to place between `Q` and quarter number.}

\item{max}{A maximum in the \code{x} vector, if \code{x} is \code{numeric},
corresponding to months (12) or quarters (4).}

\item{\ldots}{ignored.}
}
\value{
Returns a quarter formatted atomic vector.
}
\description{
Format long/abbreviation month name, integer, or date formats to a quarter
format (i.e., Q1, Q2, Q3, Q4).
}
\examples{
f_quarter(month.name)

f_quarter(1:12)

dates <- seq(as.Date("2000/1/1"), by = "month", length.out = 12)
f_quarter(dates)
\dontrun{
if (!require("pacman")) install.packages("pacman")
pacman::p_load(tidyverse)

set.seed(10)
dat <- data_frame(
    month = sample(month.name, 1000, TRUE),
    area =  sample(LETTERS[1:5], 1000, TRUE)
) \%>\%
    mutate(quarter = factor(f_quarter(month), levels = constant_quarters)) \%>\%
    count(quarter, area)

ggplot(dat, aes(quarter, n)) +
    geom_bar(stat = 'identity') +
    facet_wrap(~ area)
}
}
