% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dig_implications.R
\name{dig_implications}
\alias{dig_implications}
\title{Search for implicative rules}
\usage{
dig_implications(
  x,
  antecedent = everything(),
  consequent = everything(),
  disjoint = NULL,
  min_length = 0L,
  max_length = Inf,
  min_coverage = 0,
  min_support = 0,
  min_confidence = 0,
  contingency_table = FALSE,
  measures = NULL,
  t_norm = "goguen",
  threads = 1,
  ...
)
}
\arguments{
\item{x}{a matrix or data frame with data to search in. The matrix must be
numeric (double) or logical. If \code{x} is a data frame then each column
must be either numeric (double) or logical.}

\item{antecedent}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use in the antecedent (left) part of the rules}

\item{consequent}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use in the consequent (right) part of the rules}

\item{disjoint}{an atomic vector of size equal to the number of columns of \code{x}
that specifies the groups of predicates: if some elements of the \code{disjoint}
vector are equal, then the corresponding columns of \code{x} will NOT be
present together in a single condition.}

\item{min_length}{the minimum length, i.e., the minimum number of predicates in the
antecedent, of a rule to be generated. Value must be greater or equal to 0.
If 0, rules with empty antecedent are generated in the first place.}

\item{max_length}{The maximum length, i.e., the maximum number of predicates in the
antecedent, of a rule to be generated. If equal to Inf, the maximum length
is limited only by the number of available predicates.}

\item{min_coverage}{the minimum coverage of a rule in the dataset \code{x}.
(See Description for the definition of \emph{coverage}.)}

\item{min_support}{the minimum support of a rule in the dataset \code{x}.
(See Description for the definition of \emph{support}.)}

\item{min_confidence}{the minimum confidence of a rule in the dataset \code{x}.
(See Description for the definition of \emph{confidence}.)}

\item{contingency_table}{a logical value indicating whether to provide a contingency
table for each rule. If \code{TRUE}, the columns \code{pp}, \code{pn}, \code{np}, and \code{nn} are
added to the output table. These columns contain the number of rows satisfying
the antecedent and the consequent, the antecedent but not the consequent,
the consequent but not the antecedent, and neither the antecedent nor the
consequent, respectively.}

\item{measures}{a character vector specifying the additional quality measures to compute.
If \code{NULL}, no additional measures are computed. Possible values are \code{"lift"},
\code{"conviction"}, \code{"added_value"}.
See \url{https://mhahsler.github.io/arules/docs/measures}
for a description of the measures.}

\item{t_norm}{a t-norm used to compute conjunction of weights. It must be one of
\code{"goedel"} (minimum t-norm), \code{"goguen"} (product t-norm), or \code{"lukas"}
(Lukasiewicz t-norm).}

\item{threads}{the number of threads to use for parallel computation.}

\item{...}{Further arguments, currently unused.}
}
\value{
A tibble with found rules and computed quality measures.
}
\description{
Implicative rule is a rule of the form \eqn{A \Rightarrow c}{A => c},
where \eqn{A} (\emph{antecedent}) is a set of predicates and \eqn{c} (\emph{consequent}) is a predicate.
}
\details{
For the following explanations we need a mathematical function \eqn{supp(I)}, which
is defined for a set \eqn{I} of predicates as a relative frequency of rows satisfying
all predicates from \eqn{I}. For logical data, \eqn{supp(I)} equals to the relative
frequency of rows, for which all predicates \eqn{i_1, i_2, \ldots, i_n} from \eqn{I} are TRUE.
For numerical (double) input, \eqn{supp(I)} is computed as the mean (over all rows)
of truth degrees of the formula \verb{i_1 AND i_2 AND ... AND i_n}, where
\code{AND} is a triangular norm selected by the \code{t_norm} argument.

Implicative rules are characterized with the following quality measures.

\emph{Length} of a rule is the number of elements in the antecedent.

\emph{Coverage} of a rule is equal to \eqn{supp(A)}.

\emph{Consequent support} of a rule is equal to \eqn{supp(\{c\})}.

\emph{Support} of a rule is equal to \eqn{supp(A \cup \{c\})}.

\emph{Confidence} of a rule is the fraction \eqn{supp(A) / supp(A \cup \{c\})}.
}
\seealso{
\code{\link[=dig]{dig()}}
}
\author{
Michal Burda
}
