% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-involvement-survey.R
\docType{data}
\name{involvement_survey_srs}
\alias{involvement_survey_srs}
\title{Parent involvement survey: simple random sample}
\format{
A data frame with 5,000 rows and 16 variables
}
\usage{
involvement_survey_srs
}
\description{
An example dataset describing a simple random sample of 5,000 parents
of students with disabilities, from a population of 20,000.
The parent involvement survey measures a single key outcome:
whether "parents perceive that schools facilitate parent involvement
as a means of improving services and results for children with disabilities." \cr \cr
The variable \code{BASE_WEIGHT} provides the base sampling weight.
The variable \code{N_STUDENTS_IN_SCHOOL} can be used to provide a finite population correction
for variance estimation.
}
\section{Fields}{


\describe{
\item{UNIQUE_ID}{A unique identifier for students}
\item{RESPONSE_STATUS}{Survey response/eligibility status: 'Respondent', 'Nonrespondent', 'Ineligble', 'Unknown'}
\item{WHETHER_PARENT_AGREES}{Parent agreement ('AGREE' or 'DISAGREE') for whether they perceive that schools facilitate parent involvement}
\item{SCHOOL_DISTRICT}{A unique identifier for school districts}
\item{SCHOOL_ID}{A unique identifier for schools, nested within districts}
\item{STUDENT_GRADE}{Student's grade level: 'PK', 'K', 1-12}
\item{STUDENT_AGE}{Student's age, measured in years}
\item{STUDENT_DISABILITY_CODE}{Code for student's disability category (e.g. 'VI' for 'Visual Impairments')}
\item{STUDENT_DISABILITY_CATEGORY}{Student's disability category (e.g. 'Visual Impairments')}
\item{STUDENT_SEX}{'Female' or 'Male'}
\item{STUDENT_RACE}{Seven-level code with descriptive label (e.g. 'AS7 (Asian)')}
\item{PARENT_HAS_EMAIL}{Whether parent has an e-mail address ('Has Email' vs 'No Email')}
\item{PARENT_HAS_EMAIL_BENCHMARK}{Population benchmark for category of \code{PARENT_HAS_EMAIL}}
\item{PARENT_HAS_EMAIL_BENCHMARK}{Population benchmark for category of \code{STUDENT_RACE}}
\item{BASE_WEIGHT}{Sampling weight to use for weighted estimates}
\item{N_STUDENTS}{Total number of students in the population}
}
}

\examples{
involvement_survey_srs
}
\keyword{datasets}
