% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npsp-package.R
\docType{package}
\name{npsp-package}
\alias{npsp-package}
\alias{npsp}
\title{npsp: Nonparametric spatial (geo)statistics}
\description{
This package implements nonparametric methods 
for inference on multidimensional spatial (or spatio-temporal) processes,
which may be (especially) useful in (automatic) geostatistical modeling and interpolation.
}
\section{Main functions}{

\strong{Nonparametric methods for inference on both spatial trend 
and variogram functions}:

\code{\link{np.fitgeo}} (automatically) fits an isotropic nonparametric geostatistical model
by estimating the trend and the variogram (using a bias-corrected estimator) iteratively
(by calling \code{\link{h.cv}}, \code{\link{locpol}}, \code{\link{np.svariso.corr}} and 
\code{\link{fitsvar.sb.iso}} at each iteration).

\code{\link{locpol}}, \code{\link{np.den}} and \code{\link{np.svar}}
use local polynomial kernel methods to compute
nonparametric estimates of a multidimensional regression function,
a probability density function or a semivariogram (or their first
derivatives), respectively.
Estimates of these functions can be constructed for any dimension
(the amount of available memory is the only limitation).
To speed up computations, linear binning is used to discretize the data.
A full bandwidth matrix and a multiplicative triweight kernel is used
to compute the weights. Main calculations are performed in FORTRAN
using the LAPACK library.

\code{\link{np.svariso.corr}} computes a bias-corrected nonparametric semivariogram 
estimate using an iterative algorithm similar to that described in  
Fernandez-Casal and Francisco-Fernandez (2014). This procedure tries to correct
the bias due to the direct use of residuals, obtained from a 
nonparametric estimation of the trend function, in semivariogram estimation.

\code{\link{fitsvar.sb.iso}} fits a `nonparametric' isotropic Shapiro-Botha variogram
model by WLS. Currently, only isotropic semivariogram estimation is supported.

\strong{Nonparametric residual kriging} (sometimes called external drift kriging):

\code{np.kriging} computes residual kriging predictions  
(and the corresponding simple kriging standard errors).

\code{kriging.simple} computes simple kriging predictions, standard errors  

Currently, only global simple kriging is implemented in this package.  
Users are encouraged to use \code{\link[gstat]{krige}} (or \code{\link[gstat]{krige.cv}}) 
utilities in \pkg{gstat} package together with \code{\link{as.vgm}} for local kriging.
}

\section{Other functions}{

Among the other functions intended for direct access by the user, the following 
(methods for multidimensional linear binning, local polynomial kernel regression, 
density or variogram estimation) could be emphasized: \code{\link{binning}}, \code{\link{bin.den}},
\code{\link{svar.bin}}, \code{\link{h.cv}} and \code{\link{interp}}.

There are functions for plotting data joint with a legend representing a
continuous color scale. \code{\link{splot}} allows to combine a standard R plot 
with a legend. \code{\link{spoints}}, \code{\link{simage}} and \code{\link{spersp}} 
draw the corresponding high-level plot with a legend strip for the color scale.
These functions are based on \code{\link[fields]{image.plot}} of package \pkg{fields}.

There are also some functions which can be used to interact with other packages.
For instance, \code{\link{as.variogram}} (\pkg{geoR}) or \code{\link{as.vgm}} (\pkg{gstat}).
}

\section{Acknowledgments}{

Important suggestions and contributions to some techniques included here were
made by Sergio Castillo-Paez (Universidad de las Fuerzas Armadas ESPE, Ecuador) 
and Tomas Cotos-Ya\~{n}ez (Dep. Statistics, University of Vigo, Spain).
}

\references{
Fernandez-Casal R., Castillo-Paez S. and Francisco-Fernandez M. (2018)
Nonparametric geostatistical risk mapping, \emph{Stoch. Environ. Res. Ris. Assess.}, 
\url{https://doi.org/10.1007/s00477-017-1407-y}.

Fernandez-Casal R., Castillo-Paez S. and Garcia-Soidan P. (2017)
Nonparametric estimation of the small-scale variability of heteroscedastic spatial processes, 
\emph{Spa. Sta.}, \bold{22}, 358-370, \url{https://doi.org/10.1016/j.spasta.2017.04.001}.

Fernandez-Casal R. and Francisco-Fernandez M. (2014) 
Nonparametric bias-corrected variogram estimation under non-constant trend, 
\emph{Stoch. Environ. Res. Ris. Assess.}, \bold{28}, 1247-1259.

Fernandez-Casal R., Gonzalez-Manteiga W. and  Febrero-Bande M. (2003) 
Flexible Spatio-Temporal Stationary Variogram Models, 
\emph{Statistics and Computing}, \bold{13}, 127-136.

Rupert D. and Wand M.P. (1994) Multivariate locally weighted least squares regression.
  \emph{The Annals of Statistics}, \bold{22}, 1346-1370.

Shapiro A. and Botha J.D. (1991) Variogram fitting with a general class of
  conditionally non-negative definite functions. \emph{Computational Statistics
  and Data Analysis}, \bold{11}, 87-96.

Wand M.P. (1994) Fast Computation of Multivariate Kernel Estimators.
  \emph{Journal of Computational and Graphical Statistics}, \bold{3}, 433-445.

Wand M.P. and Jones M.C. (1995) \emph{Kernel Smoothing}. Chapman and Hall, London.
}
\author{
Ruben Fernandez-Casal (Dep. Mathematics, University of A Coru\~{n}a, Spain).
Please send comments, error reports or suggestions to \email{rubenfcasal@gmail.com}.
}
\keyword{nonparametric}
\keyword{smooth}
