% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocCV.R
\name{rocCV}
\alias{rocCV}
\title{Calculate the Receiver Operating Characteristics with Cross-validation or Subsampling}
\usage{
rocCV(x = NULL, y, method = c("logistic", "penlog", "svm", "randomforest",
  "lda", "nb", "ada", "tree"), metric = "CV", n.folds = 5,
  train.frac = 0.5, n.cores = 1, randSeed = 0, ...)
}
\arguments{
\item{x}{n * p observation matrix. n observations, p covariates.}

\item{y}{n 0/1 observatons.}

\item{method}{classification method(s).
\itemize{
\item logistic: Logistic regression. \link{glm} function with family = 'binomial'
\item penlog: Penalized logistic regression with LASSO penalty. \code{\link[glmnet]{glmnet}} in \code{glmnet} package
\item svm: Support Vector Machines. \code{\link[e1071]{svm}} in \code{e1071} package
\item randomforest: Random Forest. \code{\link[randomForest]{randomForest}} in \code{randomForest} package
\item Linear Discriminant Analysis. lda: \code{\link[MASS]{lda}} in \code{MASS} package
\item nb: Naive Bayes. \code{\link[e1071]{naiveBayes}} in \code{e1071} package
\item ada: Ada-Boost. \code{\link[ada]{ada}} in \code{ada} package
}}

\item{metric}{metric used for averging performance. Includes 'CV' and 'SS' as options. Default = 'CV'.}

\item{n.folds}{number of folds used for cross-validation or the number of splits in the subsampling. Default = 5.}

\item{train.frac}{fraction of training data in the subsampling process. Default = 0.5.}

\item{n.cores}{number of cores used for parallel computing. Default = 1.}

\item{randSeed}{the random seed used in the algorithm. Default = 0.}

\item{...}{additional arguments.}
}
\value{
A list.
\item{fpr}{sequence of false positive rate.}
\item{tpr}{sequence of true positive rate.}
}
\description{
\code{rocCV} calculates the receiver operating characterisitc with cross-validation
}
\examples{
n = 200
x = matrix(rnorm(n*2),n,2)
c = 1 - 3*x[,1]
y = rbinom(n,1,1/(1+exp(-c)))
fit = rocCV(x, y, method = 'svm')
fit2 = rocCV(x, y, method = 'penlog')
fit3 = rocCV(x, y, method = 'penlog', metric = 'SS')
}
\references{
Xin Tong, Yang Feng, and Jingyi Jessica Li (2016), Neyman-Pearson (NP) classification algorithms and NP receiver operating characteristic (NP-ROC), manuscript, http://arxiv.org/abs/1608.03109
}
\seealso{
\code{\link{nproc}}
}
