% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.frfast.R
\name{plot.frfast}
\alias{plot.frfast}
\title{Visualization of \code{frfast} objects}
\usage{
\method{plot}{frfast}(x = model, y, fac = NULL, der = NULL,
  points = TRUE, xlab = model$name[2], ylab = model$name[1],
  ylim = NULL, main = NULL, col = "black", CIcol = "black",
  ablinecol = "red", abline = TRUE, type = "l", CItype = "l", lwd = 2,
  CIlwd = 1, lty = 1, CIlty = 2, ...)
}
\arguments{
\item{x}{\code{frfast} object.}

\item{y}{NULL.}

\item{fac}{Vector which determines the level to take into account
in the plot. By default is \code{NULL}.}

\item{der}{Number or vector which determines any inference process. 
By default \code{der} is \code{NULL}. If this term is \code{0}, the plot 
shows the initial estimate. If it is \code{1} or \code{2},
it is designed for the first or second derivative, respectively.}

\item{points}{Draw the original data into the plot. By default it is
\code{TRUE}.}

\item{xlab}{A title for the \code{x} axis.}

\item{ylab}{A title for the \code{y} axis.}

\item{ylim}{The \code{y} limits of the plot.}

\item{main}{An overall title for the plot.}

\item{col}{A specification for the default plotting color.}

\item{CIcol}{A specification for the default confidence intervals
plotting color.}

\item{ablinecol}{The color to be used for \code{abline}.}

\item{abline}{Draw an horizontal line into the plot of the second derivative 
of the model.}

\item{type}{What type of plot should be drawn. Possible types are,
\code{p} for points, \code{l} for lines, \code{o} for overplotted, etc. 
See details in \code{\link{par}}.}

\item{CItype}{What type of plot should be drawn for confidence intervals. 
Possible types are, \code{p} for points, \code{l} for lines, \code{o} 
for overplotted.}

\item{lwd}{The line width, a positive number, defaulting to 1.
See details in \code{\link{par}}.}

\item{CIlwd}{The line width for confidence intervals, a positive number, 
defaulting to 1.}

\item{lty}{The line type. Line types can either be specified as an integer
(0 = blank, 1 = solid (default), 2 = dashed, 3 = dotted, 4 = dotdash, 
5 = longdash, 6 = twodash).  See details in \code{\link{par}}.}

\item{CIlty}{The line type for confidence intervals. Line types can either 
be specified as an integer (0 = blank, 1 = solid (default), 2 = dashed,
3 = dotted, 4 = dotdash, 5 = longdash, 6 = twodash).}

\item{\ldots}{Other options.}
}
\value{
Simply produce a plot.
}
\description{
Useful for drawing the estimated regression function, 
first and second derivative (for each factor's level).
}
\examples{
library(npregfast)
data(barnacle)

# Nonparametric regression without interactions
fit <- frfast(DW ~ RC, data = barnacle, nboot = 100) 
plot(fit)
plot(fit, der = 0)
plot(fit, der = 0, points = FALSE)
plot(fit, der = 1, col = "red", CIcol = "blue")

# Nonparametric regression with interactions
fit2 <- frfast(DW ~ RC : F, data = barnacle, nboot = 100) 
plot(fit2)
plot(fit2, der = 0, fac = "lens")
plot(fit2, der = 1, col = "grey", CIcol = "red")
plot(fit2, der = c(0,1), fac = c("barca","lens"))

}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}

