% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAnimalsWithHighKinship.R
\name{getAnimalsWithHighKinship}
\alias{getAnimalsWithHighKinship}
\title{Forms a list of animal Ids and animals related to them}
\usage{
getAnimalsWithHighKinship(kmat, ped, threshold, currentGroups, ignore, minAge)
}
\arguments{
\item{kmat}{numeric matrix of pairwise kinship values. Rows and columns
are named with animal IDs.}

\item{ped}{dataframe that is the `Pedigree`. It contains pedigree
information including the IDs listed in \code{candidates}.}

\item{threshold}{numeric value indicating the minimum kinship level to be
considered in group formation. Pairwise kinship below this level will be
ignored.}

\item{currentGroups}{list of character vectors of IDs of animals currently
assigned
to the group. Defaults to character(0) assuming no groups are existent.}

\item{ignore}{list of character vectors representing the sex combinations
to be ignored. If provided, the vectors in the list specify if pairwise
kinship should be ignored between certain sexes.
Default is to ignore all pairwise kinship between females.}

\item{minAge}{integer value indicating the minimum age to consider in group
formation. Pairwise kinships involving an animal of this age or younger will
 be ignored. Default is 1 year.}
}
\value{
A list of named character vectors where each name is an animal Id
and the character vectors are made up of animals sharing a kinship value
greater than our equal to the \code{threshold} value.
}
\description{
Forms a list of animal Ids and animals related to them
}
\examples{
\donttest{
examplePedigree <- nprcgenekeepr::examplePedigree
ped <- qcStudbook(examplePedigree, minParentAge = 2, reportChanges = FALSE,
                  reportErrors = FALSE)
kmat <- kinship(ped$id, ped$sire, ped$dam, ped$gen, sparse = FALSE)
currentGroups <- list(1)
currentGroups[[1]] <- examplePedigree$id[1:3]
candidates <- examplePedigree$id[examplePedigree$status == "ALIVE"]
threshold <- 0.015625
kin <- getAnimalsWithHighKinship(kmat, ped, threshold, currentGroups,
                                 ignore = list(c("F", "F")), minAge = 1)
length(kin) # should be 2412
kin[["1SPLS8"]] # should have 14 IDs
}
}
