% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_extraction.R
\name{base_extraction}
\alias{base_extraction}
\title{Extract time series and create a base}
\usage{
base_extraction(series_code)
}
\arguments{
\item{series_code}{Vector with the series encoding follow the Bacen (Banco Central do Brasil) standards.}
}
\value{
A \code{mts} in the same specification required in argument \code{base} of function \code{nowcasting}
}
\description{
Create a time series matrix \code{mts} used to estimate the commmon factors.
}
\examples{
# Extracting GDP serie at real-time from Central Bank of Brasil data base
gdp<-base_extraction(22099)

# Extracting Vehicles production (1373) serie at real-time from Central Bank of Brasil data base
vei_prod<-base_extraction(1373)


\dontrun{
# Industrial production (21859) serie at real-time from Central Bank of Brasil data base
ind_prod<-base_extraction(21859)

# Creating real time data base with the series: 
# Vehicles production (1373);
# Industrial production, general index (21859).
mybase<-base_extraction(c(1373,21859))

# Creating real time data base with the series: 
# Exchange rate - Free - United States dollar (1);
#  Interest rate - CDI (12).
mybase<-base_extraction(c(1,12))

# Creating real time data base with the series: 
# Vehicles production (1373);
# Credit Sales Index (1453);
# Retail sales (1455);
# Industrial production, general index (21859).
mybase<-base_extraction(c(1373,1453,1455,21859))}

}
\references{
Central Bank of Brazil
}
