% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-none.R
\name{dualNone}
\alias{dualNone}
\title{Dual-host pathogen in homogeneous hosts populations}
\usage{
dualNone(length.sim, max.infected.A, max.infected.B, init.individuals.A,
  init.individuals.B, pExit.A, param.pExit.A, timeDep.pExit.A = FALSE,
  nContact.A, param.nContact.A, timeDep.nContact.A = FALSE, pTrans.A,
  param.pTrans.A, timeDep.pTrans.A = FALSE, prefix.host.A = "H",
  pExit.B, param.pExit.B, timeDep.pExit.B = FALSE, nContact.B,
  param.nContact.B, timeDep.nContact.B = FALSE, pTrans.B, param.pTrans.B,
  timeDep.pTrans.B = FALSE, prefix.host.B = "V",
  print.progress = TRUE, print.step = 10)
}
\arguments{
\item{length.sim}{specifies the length (in unit of time) over which the simulation should be run.}

\item{max.infected.A}{specifies the maximum number of individual hosts A that can be infected in the simulation.}

\item{max.infected.B}{specifies the maximum number of individual hosts B that can be infected in the simulation.}

\item{init.individuals.A}{number of initially infected individuals (hosts A).}

\item{init.individuals.B}{number of initially infected individuals (hosts B).}

\item{pExit.A}{function that gives the probability to exit the simulation for an infected host A (either moving out, dying, etc.).}

\item{param.pExit.A}{parameter names (list of functions) for the pExit for host-type A.}

\item{timeDep.pExit.A}{is pExit of host-type A dependent on the absolute time of the simulation (TRUE/FALSE)?}

\item{nContact.A}{function that gives the number of potential transmission events per unit of time for host-type A.}

\item{param.nContact.A}{parameter names (list of functions) for param.nContact for host-type A.}

\item{timeDep.nContact.A}{is nContact of host-type A dependent on the absolute time of the simulation (TRUE/FALSE)?}

\item{pTrans.A}{function that gives the probability of transmit a pathogen as a function of time since infection for host A.}

\item{param.pTrans.A}{parameter names (list of functions) for the pExit  for host A.}

\item{timeDep.pTrans.A}{is pTrans of host-type A dependent on the absolute time of the simulation (TRUE/FALSE)?}

\item{prefix.host.A}{character(s) to be used as a prefix for the host A identification number.}

\item{pExit.B}{function that gives the probability to exit the simulation for an infected host B (either moving out, dying, etc.).}

\item{param.pExit.B}{parameter names (list of functions) for the pExit for host-type B.}

\item{timeDep.pExit.B}{is pExit of host-type B dependent on the absolute time of the simulation (TRUE/FALSE)?}

\item{nContact.B}{function that gives the number of potential transmission events per unit of time for host B.}

\item{param.nContact.B}{parameter names (list of functions) for param.nContact for host-type B.}

\item{timeDep.nContact.B}{is nContact of host-type B dependent on the absolute time of the simulation (TRUE/FALSE)?}

\item{pTrans.B}{function that gives the probability of transmit a pathogen as a function of time since infection for host B.}

\item{param.pTrans.B}{parameter names (list of functions) for the pExit for host-type B.}

\item{timeDep.pTrans.B}{is pTrans of host-type B dependent on the absolute time of the simulation (TRUE/FALSE)?}

\item{prefix.host.B}{character(s) to be used as a prefix for the host B identification number.}

\item{print.progress}{if TRUE, displays a progress bar (current time/length.sim).}

\item{print.step}{print.progress is TRUE, step with which the progress message will be printed.}
}
\value{
An object of class \code{\link{nosoiSim}}, containing all results of the simulation.
}
\description{
This function, that can be wrapped within \code{\link{nosoiSim}}, runs a dual-host transmission chain simulation, without any structure features in both hosts populations. The simulation stops either at
the end of given time (specified by \code{length.sim}) or when the number of hosts infected threshold (\code{max.infected}) is crossed.
}
\details{
The \code{pExit} and \code{pTrans} functions should return a single probability (a number between 0 and 1), and \code{nContact} a positive natural number (positive integer) or 0.

The \code{param} arguments should be a list of functions or NA. Each item name in the parameter list should have the same name as the argument in the corresponding function.

The use of \code{timeDep} (switch to \code{TRUE}) makes the corresponding function use the argument \code{prestime} (for "present time").
}
\section{Suffixes}{

The suffix \code{.A} or \code{.B} specifies if the considered function or parameter concerns host type A or B.
}

\section{Order of Arguments}{

The user specified function's arguments should follow this order: \code{t} (mandatory), \code{prestime} (optional, only if timeDep is TRUE), \code{parameters} specified in the list.
}

\examples{
\donttest{
 #Host A
t_infectA_fct <- function(x){rnorm(x,mean = 12,sd=3)}
pTrans_hostA <- function(t,t_infectA){
  if(t/t_infectA <= 1){p=sin(pi*t/t_infectA)}
  if(t/t_infectA > 1){p=0}
  return(p)
}

p_Exit_fctA  <- function(t,t_infectA){
  if(t/t_infectA <= 1){p=0}
  if(t/t_infectA > 1){p=1}
  return(p)
}

time_contact_A = function(t){sample(c(0,1,2),1,prob=c(0.2,0.4,0.4))}

#Host B
t_incub_fct_B <- function(x){rnorm(x,mean = 5,sd=1)}
p_max_fct_B <- function(x){rbeta(x,shape1 = 5,shape2=2)}

p_Exit_fct_B  <- function(t,prestime){(sin(prestime/12)+1)/5}

pTrans_hostB <- function(t,p_max,t_incub){
  if(t <= t_incub){p=0}
  if(t >= t_incub){p=p_max}
  return(p)
}

time_contact_B = function(t){round(rnorm(1, 3, 1), 0)}

set.seed(90)
test.nosoi <- nosoiSim(type="dual", popStructure="none",
                       length.sim=40,
                       max.infected.A=100,
                       max.infected.B=200,
                       init.individuals.A=1,
                       init.individuals.B=0,
                       pExit.A = p_Exit_fctA,
                       param.pExit.A = list(t_infectA = t_infectA_fct),
                       timeDep.pExit.A=FALSE,
                       nContact.A = time_contact_A,
                       param.nContact.A = NA,
                       timeDep.nContact.A=FALSE,
                       pTrans.A = pTrans_hostA,
                       param.pTrans.A = list(t_infectA=t_infectA_fct),
                                             timeDep.pTrans.A=FALSE,
                       prefix.host.A="H",
                       pExit.B = p_Exit_fct_B,
                       param.pExit.B = NA,
                       timeDep.pExit.B=TRUE,
                       nContact.B = time_contact_B,
                       param.nContact.B = NA,
                       timeDep.nContact.B=FALSE,
                       pTrans.B = pTrans_hostB,
                       param.pTrans.B = list(p_max=p_max_fct_B,
                                            t_incub=t_incub_fct_B),
                       timeDep.pTrans.B=FALSE,
                       prefix.host.B="V")

test.nosoi
}

}
\seealso{
For simulations with a discrete structured host population, see \code{\link{dualDiscrete}}. For simulations with a structured population in continuous space, \code{\link{dualContinuous}}
}
