% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superset.R
\name{superspec.character}
\alias{superspec.character}
\title{Create Specification for Model Inputs and Outputs From Character}
\usage{
\method{superspec}{character}(x, include = character(0),
  exclude = character(0), rename = NULL, visible = "VISIBLE",
  after = NULL, data = NULL, ...)
}
\arguments{
\item{x}{character}

\item{include}{column names in output to consider adding}

\item{exclude}{column names in output to reject}

\item{rename}{logical: whether to keep and rename columns with re-used names}

\item{visible}{a name for the flag column indicating visibility}

\item{after}{place new columns after this column; at end by default (NULL); TRUE places them after}

\item{data}{an alternative dataset on which to model the specification}

\item{...}{passed arguments}
}
\description{
Create a specification for the result of superset() from character by treating as a model name. By default, gives a spec template for superset(x). Tries to supplement with labels and units from parent specification, if it exists.  Tries to supplement with any additional labels and units in definitions(x).  Defers to actual data if provided. Specify \code{exclusive}, \code{visible}, and \code{after} as for \code{superset}.
}
