% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx.R
\name{as.docx}
\alias{as.docx}
\alias{as.docx.docx}
\alias{as.docx.data.frame}
\alias{as.docx.partab}
\title{Coerce to docx}
\usage{
as.docx(x, ...)

\method{as.docx}{docx}(x, ...)

\method{as.docx}{data.frame}(x, title = "untitled", template,
  empty_template = FALSE,
  list.definition = getOption("ReporteRs-list-definition"), ...)

\method{as.docx}{partab}(x, title = "parameter table", template,
  empty_template = FALSE,
  list.definition = getOption("ReporteRs-list-definition"), ...)
}
\arguments{
\item{x}{object of dispatch}

\item{...}{arguments to methods}

\item{title}{passed to docx}

\item{template}{passed to docx}

\item{empty_template}{passed to docx}

\item{list.definition}{passed to docx}
}
\value{
docx

docx

docx

docx
}
\description{
Coerces to docx.

Coerces docx to docx.

Coerces data.frame to docx

Coerces partab to docx.
}
\details{
Returns the object.
}
\section{Methods (by class)}{
\itemize{
\item \code{docx}: docx method

\item \code{data.frame}: data.frame method

\item \code{partab}: partab method
}}

\examples{
\donttest{
library(magrittr)
options(project = system.file('project/model',package='nonmemica'))
1001 \%>\% partab \%>\% as.docx \%>\% as.file('1001.docx')
}
}
\seealso{
\code{\link{as.docx.data.frame}}

\code{\link[ReporteRs]{docx}}

\code{\link[ReporteRs]{addFlexTable}}

\code{\link[ReporteRs]{FlexTable}}
}
