% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cardinal.R
\name{cardinal}
\alias{cardinal}
\alias{nom_card}
\title{Convert numbers to cardinal character vectors (one, two, three)}
\usage{
cardinal(
  x,
  max_n = get_config("nombre::max_n", Inf),
  negative = get_config("nombre::negative", "negative"),
  ...
)

nom_card(
  x,
  max_n = get_config("nombre::max_n", Inf),
  negative = get_config("nombre::negative", "negative"),
  ...
)
}
\arguments{
\item{x}{A numeric vector}

\item{max_n}{A numeric vector.
When the absolute value of \code{x} is greater than \code{max_n}, \code{x} remains
numeric instead of being converted to words.
If \code{max_n} is negative, no \code{x}s will be converted to words.
(This can be useful when \code{max_n} is passed by another function.)
Defaults to \code{Inf}, which converts all \code{x}s to words.
Default can be changed with \link[=set_config]{set_config("nombre::max_n")}.}

\item{negative}{A character vector to append to negative numbers.
Defaults to \code{"negative"}.
Default can be changed with
\link[=set_config]{set_config("nombre::negative")}.}

\item{...}{Additional arguments passed to \code{\link[fracture:frac_mat]{fracture::frac_mat()}}.
See details.}
}
\value{
A character vector of the same length as \code{x}
}
\description{
Convert numbers to cardinal character vectors (one, two, three)
}
\section{Fractions:}{
Decimal components of \code{x} are automatically converted to fractions by
\code{\link[fracture:frac_mat]{fracture::frac_mat()}}.
Named arguments of \code{cardinal()} and \code{nom_card()} are passed to
\code{\link[fracture:frac_mat]{fracture::frac_mat()}} through \code{...}.
Helpful arguments include:
\itemize{
\item \code{base_10 = TRUE}, which forces all fractions to use denominators that are
powers of ten
\item \code{common_denom = TRUE}, which forces all fractions to use the least common
denominator when \code{x} is a vector
\item \code{max_denom}, which sets the maximum allowable denominator.
By default, the maximum denominator is "ten-millionths".
}
}

\examples{
nom_card(2)
nom_card(1:10)
nom_card(2 + 4/9)
nom_card(-2)
nom_card(-2, negative = "minus")

nom_card(5:15, max_n = 10)

paste("There are", nom_card(525600), "minutes in a year.")
paste("There are", nom_card(3.72e13), "cells in the human body.")

nom_card(1 / 2^(1:4))
nom_card(1 / 2^(1:4), common_denom = TRUE)
nom_card(1 / 2^(1:4), base_10 = TRUE)
nom_card(1 / 2^(1:4), base_10 = TRUE, common_denom = TRUE)

nom_card(1 / 2:5)
nom_card(1 / 2:5, base_10 = TRUE)
nom_card(1 / 2:5, base_10 = TRUE, max_denom = 100)
}
\seealso{
\code{\link[=uncardinal]{uncardinal()}} to convert character vectors to numbers

Other number names: 
\code{\link{adverbial}()},
\code{\link{collective}()},
\code{\link{denominator}()},
\code{\link{numerator}()},
\code{\link{ordinal}()}
}
\concept{number names}
