% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliaryFunctions.R
\name{ARI}
\alias{ARI}
\title{Evalute the adjusted Rand index}
\usage{
ARI(x, y)
}
\arguments{
\item{x}{vector (of length n) or matrix (with n columns) providing a partition}

\item{y}{vector or matrix providing a partition}
}
\value{
the value of the adjusted Rand index
}
\description{
Compute the adjusted Rand index to compare two partitions
}
\details{
the partitions may be provided as n-vectors containing the cluster memeberships
of n entities, or by Qxn - matrices whose entries are all
0 and 1 where 1 indicates the cluster membership
}
\examples{
clust1 <- c(1,2,1,2)
clust2 <- c(2,1,2,1)
ARI(clust1, clust2)

clust3 <- matrix(c(1,1,0,0, 0,0,1,1), nrow=2, byrow=TRUE)
clust4 <- matrix(c(1,0,0,0, 0,1,0,0, 0,0,1,1), nrow=3, byrow=TRUE)
ARI(clust3, clust4)
}
