% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{docdb_update}
\alias{docdb_update}
\title{Update documents}
\usage{
docdb_update(src, key, value, query, ...)
}
\arguments{
\item{src}{Source object, result of call to any of functions
\code{\link[=src_mongo]{src_mongo()}}, \code{\link[=src_sqlite]{src_sqlite()}}, \code{\link[=src_elastic]{src_elastic()}}, \code{\link[=src_couchdb]{src_couchdb()}}
or \code{\link[=src_postgres]{src_postgres()}}}

\item{key}{(character) A key as name of the container
(corresponds to parameter \code{collection} for MongoDB,
\code{dbname} for CouchDB, \code{index} for Elasticsearch and to
a table name for SQLite and for PostgreSQL)}

\item{value}{The data to be created in the database:
a single data.frame, a JSON string or a list}

\item{query}{(character) A JSON query string, see examples}

\item{...}{Passed on to functions:
\itemize{
\item CouchDB: \code{\link[sofa:db_bulk_create]{sofa::db_bulk_create()}}
\item Elasticsearch: \link[elastic:docs_bulk_update]{elastic::docs_bulk_update}
\item MongoDB: \code{\link[mongolite:mongo]{mongolite::mongo()}}
\item SQLite: ignored
\item PostgreSQL: ignored
}}
}
\value{
(integer) Number of successfully updated documents
}
\description{
Documents identified by the query are updated
by patching their JSON with \code{value}.
This is native with MongoDB and SQLite and is
emulated for Elasticsearch and CouchDB using
SQLite/JSON1, and uses a plpgsql function for
PostgreSQL.
}
\examples{
\dontrun{
src <- src_sqlite()
docdb_create(src, "mtcars", mtcars)
docdb_update(src, "mtcars", value = mtcars[3, 4:5], query = '{"gear": 3}')
docdb_update(src, "mtcars", value = '{"carb":999}', query = '{"gear": 5}')
docdb_get(src, "mtcars")
}
}
