% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{rrot.clust}
\alias{rrot.clust}
\title{Generation of Points with Rotational Clusters}
\usage{
rrot.clust(
  n,
  k,
  d,
  sd = d * sqrt(2 * (1 - cos(2 * pi/k)))/3,
  distribution = c("uniform", "bvnormal")
)
}
\arguments{
\item{n}{A positive integer representing the number of points to be generated from all the clusters}

\item{k}{A positive integer representing the number of clusters to be generated}

\item{d}{Radial shift indicating the level of clustering in the data. Larger absolute values in either
direction (i.e. positive or negative) would yield stronger clustering.}

\item{sd}{The standard deviation of the components of the bivariate normal distribution with default 
\eqn{sd=d\sqrt{2 (1-cos(2 \pi/k))}/3}, used only when \code{distribution="bvnormal"}.}

\item{distribution}{The argument determining the distribution of each cluster. Takes on values \code{"uniform"} and
\code{"bvnormal"} whose centers are \eqn{d} units apart along the horizontal direction.}
}
\value{
A \code{list} with the elements
\item{type}{The type of the clustering pattern}
\item{parameters}{The number of clusters, \code{k}, and the radial shift, \code{d}, representing the level of clustering
(for both distribution types) and standard deviation, \code{sd}, for the bivariate normal distribution only.}
\item{gen.points}{The output set of generated points from the \code{k} clusters.}
\item{desc.pat}{Description of the clustering pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The number of generated points.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated points}
}
\description{
An object of class \code{"Clusters"}.

Generates \code{n} 2D points with \code{k} (\eqn{k \ge 2}) clusters with centers d unit away from origin and angles
between the rays joining successive centers and origin is \eqn{2 \pi/k} where about \eqn{n/k} points belongs to each cluster.

If \code{distribution="uniform"}, the points are uniformly generated in their square
supports with unit edge lengths and centers at \eqn{(d \cos(j 2 \pi/k),d \cos(j 2\pi/k))} for \eqn{j=1,2,\ldots,k}.

If \code{distribution="bvnormal"}, the points are generated from the bivariate normal distribution with means equal to the
centers of the above squares (i.e. for each cluster with \code{mean=}\eqn{(d \cos(j 2 \pi/k),d \cos(j 2\pi/k))}
for \eqn{j=1,2,\ldots,k} and the covariance matrix \eqn{sd I_2}, where \eqn{sd=d\sqrt{2 (1-cos(2 \pi/k))}/3}
and \eqn{I_2} is the \eqn{2 \times 2} identity matrix.

Notice that the clusters are more separated, i.e., generated data indicates more clear clusters as \eqn{d} increases
in either direction with \eqn{d=0} indicating one cluster in the data. For a fixed \eqn{d}, when \code{distribution="bvnormal"},
the clustering gets stronger if the variance of each component, \eqn{sd^2}, gets smaller, and clustering gets weaker
as the variance of each component gets larger where default is \eqn{sd=d\sqrt{2 (1-cos(2 \pi/k))}/3}.
}
\examples{
n<-100;  #try also n<-50; n<-1000;
d<- 1.5 #try also -1, 1, 1.5, 2
k<-3 #try also 5
#data generation
Xdat<-rrot.clust(n,k,d)
Xdat

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#data generation (bvnormal)
n<-100;  #try also n<-50; n<-1000;
d<- 1.5 #try also -1, 1, 1.5, 2
k<-3 #try also 5
Xdat<-rrot.clust(n,k,d,distr="bvnormal") #also try Xdat<-rrot.clust(n,k,d,sd=.5,distr="bvnormal")
Xdat

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

}
\seealso{
\code{\link{rdiag.clust}} and \code{\link{rhor.clust}}
}
\author{
Elvan Ceyhan
}
