% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{rassocG}
\alias{rassocG}
\title{Generation of Points Associated in the Type G Sense with a Given Set of Points}
\usage{
rassocG(X1, n2, sigma)
}
\arguments{
\item{X1}{A set of 2D points representing the reference points, also referred as class 1 points.
The generated points are associated in a type G sense with these points.}

\item{n2}{A positive integer representing the number of class 2 points to be generated.}

\item{sigma}{A positive real number representing the variance of the Gaussian marginals, where
the bivariate normal distribution has covariance \code{BVN((0,0),sigma*I_2)} with \eqn{I_2} being the \eqn{2 \times 2} identity matrix.}
}
\value{
A \code{list} with the elements
\item{pat.type}{=\code{"ref.gen"} for the bivariate pattern of association of class 2 points with the reference points
(i.e. \eqn{X_1}), indicates reference points are required to be entered as an argument in the function}
\item{type}{The type of the point pattern}
\item{parameters}{The variance of the Gaussian marginals controlling the level of association, where
the bivariate normal distribution has covariance \eqn{\sigma I_2} with \eqn{I_2} being the \eqn{2 \times 2} identity matrix.}
\item{gen.points}{The output set of generated points (i.e. class 2 points) associated with reference (i.e.
\eqn{X_1} points)}
\item{ref.points}{The input set of reference points \eqn{X_1}, i.e., points with which generated class 2 points
are associated.}
\item{desc.pat}{Description of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The \code{vector} of two numbers, which are the number of generated class 2 points and
the number of reference (i.e. \eqn{X_1}) points.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated and the reference points}
}
\description{
An object of class \code{"SpatPatterns"}.

Generates \code{n_2} 2D points associated with the given set of points (i.e. reference points) \eqn{X_1} in the
type G fashion with the parameter sigma which is a positive real number representing the variance of the
Gaussian marginals.
The generated points are intended to be from a different class, say class 2 (or \eqn{X_2} points) than the reference
(i.e. \eqn{X_1} points, say class 1 points, denoted as \code{X1} as an argument of the function), say class 1 points). 
To generate \eqn{n_2} (denoted as \code{n2} as an argument of the function)\eqn{X_2} points, \eqn{n_2} of \eqn{X_1} points are randomly selected (possibly with replacement) and
for a selected \code{X1} point, say \eqn{x_{1ref}},
a new point from the class 2, say \eqn{x_{2new}}, is generated from a bivariate normal distribution centered at \eqn{x_{1ref}}
where the covariance matrix of the bivariate normal is a diagonal matrix with sigma in the diagonals.
That is, \eqn{x_{2new} = x_{1ref}+V} where \eqn{V \sim BVN((0,0),\sigma I_2)} with \eqn{I_2} being the \eqn{2 \times 2} identity matrix.
Note that, the level of association increases as \code{sigma} decreases, and the association vanishes when \code{sigma} 
goes to infinity.

For type G association, it is recommended to take \eqn{\sigma \le 0.10}  times length of the shorter
edge of a rectangular study region, or take \eqn{r_0 = 1/(k \sqrt{\hat \rho})} with the appropriate choice of \eqn{k} 
to get an association pattern more robust to differences in relative abundances
(i.e. the choice of \eqn{k} implies \eqn{\sigma \le 0.10} times length of the shorter edge to have alternative patterns more 
robust to differences in sample sizes).
Here \eqn{\hat \rho} is the 
estimated intensity of points in the study region (i.e., # of points divided by the area of the region). 

Type G association is closely related to Types C and U association,
see the functions \code{\link{rassocC}} and \code{\link{rassocU}} and
the other association types.
In the type C association pattern
the new point from the class 2, \eqn{x_{2new}}, is generated (uniform in the polar coordinates) within a circle
centered at \eqn{x_{1ref}} with radius equal to \eqn{r_0},
in type U association pattern \eqn{x_{2new}} is generated similarly except it is uniform in the circle.
In type I association, first a \eqn{Uniform(0,1)} number, \eqn{U}, is generated.
If \eqn{U \le p}, \eqn{x_{2new}} is generated (uniform in the polar coordinates) within a
circle with radius equal to the distance to the closest \eqn{X_1} point,
else it is generated uniformly within the smallest bounding box containing \eqn{X_1} points.

See \insertCite{ceyhan:serra-2014;textual}{nnspat} for more detail.
}
\examples{
n1<-20; n2<-1000;  #try also n1<-10; n2<-1000;

stdev<-.05  #try also .075 and .15
#with default bounding box (i.e., unit square)
X1<-cbind(runif(n1),runif(n1))   #try also X1<-1+cbind(runif(n1),runif(n1))

Xdat<-rassocG(X1,n2,stdev)
Xdat
summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#sigma adjusted with the expected NN distance
x<-range(X1[,1]); y<-range(X1[,2])
ar<-(y[2]-y[1])*(x[2]-x[1]) #area of the smallest rectangular window containing X1 points
rho<-n1/ar
stdev<-1/(4*sqrt(rho)) #r0=1/(2rho) where \code{rho} is the intensity of X1 points
Xdat<-rassocG(X1,n2,stdev)
Xdat
summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rassocI}}, \code{\link{rassocG}}, \code{\link{rassocC}}, and \code{\link{rassoc}}
}
\author{
Elvan Ceyhan
}
