% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{kNN}
\alias{kNN}
\title{Finding the indices of the \code{k} NNs of a given point}
\usage{
kNN(x, i, k, is.ipd = TRUE, ...)
}
\arguments{
\item{x}{The IPD matrix (if \code{is.ipd=TRUE}) or a data set of points in matrix or data frame form where points
correspond to the rows (if \code{is.ipd = FALSEALSE}).}

\item{i}{index of (i.e., row number for) the subject whose NN is to be found.}

\item{k}{Integer specifying the number of NNs (of subject \eqn{i}).}

\item{is.ipd}{A logical parameter (default=\code{TRUE}). If \code{TRUE}, \code{x} is taken as the inter-point distance
matrix, otherwise, \code{x} is taken as the data set with rows representing the data points.}

\item{...}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
Returns the indices (i.e. row numbers) of the \code{k} NNs of subject \eqn{i}
}
\description{
Returns the indices of the \code{k} nearest neighbors of subject \eqn{i} given data set or IPD matrix \code{x}.
Subject indices correspond to rows (i.e. rows \code{1:n} ) if \code{x} is the data set and to rows or columns
if \code{x} is the IPD matrix.  

The argument \code{is.ipd} is a logical argument (default=\code{TRUE}) to determine the structure of the argument \code{x}.
If \code{TRUE}, \code{x} is taken to be the inter-point distance (IPD) matrix, and if \code{FALSE}, \code{x} is taken to be the data set
with rows representing the data points.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
k<-sample(1:5,1)
k
NN(ipd,1)
kNN(ipd,1,k)
kNN(Y,1,k,is.ipd = FALSE)
kNN(Y,1,k,is.ipd = FALSE,method="max")

NN(ipd,5)
kNN(ipd,5,k)
kNN(Y,5,k,is.ipd = FALSE)

#1D data points
X<-as.matrix(runif(15)) # need to be entered as a matrix with one column
#(i.e., a column vector), hence X<-runif(5) would not work
ipd<-ipd.mat(X)
kNN(ipd,3,k)

#with possible ties in the data
Y<-matrix(round(runif(30)*10),ncol=3)
ny<-nrow(Y)
ipd<-ipd.mat(Y)
for (i in 1:ny)
  cat(i,":",kNN(ipd,i,k),"\n")

}
\seealso{
\code{\link{NN}}, \code{\link{NNdist}} and \code{\link{NNdist2cl}}
}
\author{
Elvan Ceyhan
}
