% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funs.overall.tct}
\alias{funs.overall.tct}
\alias{overall.tct.ct}
\alias{overall.tct}
\title{Types I-IV Overall Tests of Segregation for NNCT}
\usage{
overall.tct.ct(ct, covN, type = "III")

overall.tct(dat, lab, type = "III", ...)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{overall.tct.ct} only}

\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized entries of NNCT, \code{ct} ;
used in \code{overall.tct.ct} only.}

\item{type}{The type of the overall segregation test, default=\code{"III"}.
Takes on values \code{"I"}-\code{"IV"} (or equivalently \code{1-4}, respectively.}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{overall.tct} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{overall.tct} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function. 
used in \code{overall.tct} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The overall chi-squared statistic for the specified type}
\item{stat.names}{Name of the test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is \eqn{k(k-1)} for type=\code{"II"} and \eqn{(k-1)^2} for others.}
\item{estimate}{Estimates of the parameters, TCT, i.e., matrix of the observed \eqn{T_{ij}} values
which is the TCT.}
\item{est.name,est.name2}{Names of the estimates, former is a longer description of the estimates
than the latter.}
\item{null.value}{Matrix of hypothesized null values for the parameters which are expected values of the
the \eqn{T_{ij}} values in the TCT.}
\item{null.name}{Name of the null values}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{overall.tct.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{overall.tct} only}
}
\description{
Two functions: \code{overall.tct.ct} and \code{overall.tct}.

All functions are objects of class \code{"Chisqtest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of deviations of 
cell counts from the expected values under RL or CSR for all cells (i.e., entries) combined in the TCT.
That is, each test is one of Types I-IV overall test of segregation based on TCTs for \eqn{k \ge 2} classes.
This overall test is based on the chi-squared approximation of the corresponding quadratic form
and are due to \insertCite{ceyhan:SJScorrected2010,ceyhan:jkss-posthoc-2017;textual}{nnspat}.
Both functions exclude some row and/or column of the TCT, to avoid ill-conditioning of the covariance matrix
of the NNCT (for its inversion in the quadratic form).
In particular, type-II removes the last column, and all other types remove the last row and column.

Each function yields the test statistic, \eqn{p}-value and \code{df} which is \eqn{k(k-1)} for type II test and \eqn{(k-1)^2} 
for the other types, description of the 
alternative with the corresponding null values (i.e. expected values) of TCT entries, sample estimates (i.e. observed values) of the entries in TCT.
The functions also provide names of the test statistics, the method and the data set used.

The null hypothesis is that all Tij entries for the specified type are equal to their expected values
under RL or CSR.

See also 
(\insertCite{ceyhan:SJScorrected2010,ceyhan:jkss-posthoc-2017;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv) #default is byrow

overall.tct(Y,cls)
overall.tct(Y,cls,type="I")
overall.tct(Y,cls,type="II")
overall.tct(Y,cls,type="III")
overall.tct(Y,cls,type="IV")

overall.tct(Y,cls,method="max")

overall.tct.ct(ct,covN)
overall.tct.ct(ct,covN,type="I")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

overall.tct(Y,fcls)
overall.tct.ct(ct,covN)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

overall.tct(Y,cls)
overall.tct.ct(ct,covN)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{overall.seg.ct}}, \code{\link{overall.seg}}, \code{\link{overall.nnct.ct}}
and \code{\link{overall.nnct}}
}
\author{
Elvan Ceyhan
}
