% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{QRval}
\alias{QRval}
\title{Number of Shared and Reflexive NNs}
\usage{
QRval(njr)
}
\arguments{
\item{njr}{A \code{list} that is the output of \code{\link{Ninv}} (with first entry in the \code{list} is \code{vector} of number of shared NNs
and second is the \eqn{R} value, number of reflexive points)}
}
\value{
A \code{list} with two elements
\item{Q}{the \eqn{Q} value, the number of shared NNs}
\item{R}{the \eqn{R} value, the number of reflexive NNs}
}
\description{
Returns the \eqn{Q} and \eqn{R} values where \eqn{Q} is the number of points shared as a NN
by other points i.e. number of points that are NN of other points (which occurs when two or 
more points share a NN, for data in any dimension) and \eqn{R} is the number of reflexive pairs
where A and B are reflexive iff they are NN to each other.

These quantities are used, e.g., in computing the variances and covariances of the entries of the
nearest neighbor contingency tables used for Dixon's tests and other NNCT tests.
}
\examples{
#3D data points
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
ninv<-Ninv(ipd)
QRval(ninv)
W<-Wmat(ipd)
Qvec(W)$q

#1D data points
n<-15
X<-as.matrix(runif(n))# need to be entered as a matrix with one column 
#(i.e., a column vector), hence X<-runif(n) would not work
ipd<-ipd.mat(X)
ninv<-Ninv(ipd)
QRval(ninv)
W<-Wmat(ipd)
Qvec(W)$q

#with possible ties in the data
Y<-matrix(round(runif(30)*10),ncol=3)
ny<-nrow(Y)
ipd<-ipd.mat(Y)
ninv<-Ninv(ipd)
QRval(ninv)
W<-Wmat(ipd)
Qvec(W)$q

}
\seealso{
\code{\link{Qval}}, \code{\link{Qvec}}, \code{\link{sharedNN}}, \code{\link{Rval}} 
and \code{\link{Ninv}}
}
\author{
Elvan Ceyhan
}
