% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funs.seg.coeff}
\alias{funs.seg.coeff}
\alias{Pseg.coeff}
\alias{seg.coeff}
\title{Pielou's Segregation Coefficients for NNCTs}
\usage{
Pseg.coeff(ct)

seg.coeff(ct)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in both functions}
}
\value{
\code{Pseg.coeff} returns Pielou's segregation coefficient for \eqn{2 \times 2} NNCT
\code{seg.coeff} returns a \eqn{k \times k} matrix of segregation coefficients (which are extended versions
of Pielou's segregation coefficient)
}
\description{
Two functions: \code{Pseg.coeff} and \code{seg.coeff}.

Each function computes segregation coefficients based on NNCTs.
The function \code{Pseg.coeff} computes Pielou's segregation coefficient (\insertCite{pielou:1961;textual}{nnspat})
for the two-class case (i.e., based on \eqn{2 \times 2} NNCTs)
and \code{seg.coeff} is the extension of \code{Pseg.coeff} to the multi-class case (i.e. for \eqn{k \times k} NNCTs with \eqn{k \ge 2})
and provides a \eqn{k \times k} matrix of segregation coefficients
(\insertCite{ceyhan:SiM-seg-ind2014;textual}{nnspat}).
Both functions use the same argument, \code{ct}, for NNCT.

Pielou's segregation coefficient (for two classes) is \eqn{S_P = 1-(N_{12} + N_{21})/(E[N_{12}] + E[N_{21}])}
and the extended segregation coefficents (for \eqn{k \ge 2} classes) are 
\eqn{S_c = 1 -(N_{ii})/(E[N_{ii}])} for the diagonal cells in the NNCT
and
\eqn{S_c = 1 -(N_{ij} + N_{ji})/(E[N_{ij}] + E[N_{ji}])} for the off-diagonal cells in the NNCT.
}
\examples{
#Examples for Pseg.coeff
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct
Pseg.coeff(ct)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

Pseg.coeff(ct)

#############
ct<-matrix(sample(1:25,9),ncol=3)
#Pseg.coeff(ct)

#Examples for seg.coeff
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct
seg.coeff(ct)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

seg.coeff(ct)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ipd<-ipd.mat(Y)
ct<-nnct(ipd,cls)

seg.coeff(ct)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{seg.ind}}, \code{\link{Zseg.coeff.ct}} and \code{\link{Zseg.coeff}}
}
\author{
Elvan Ceyhan

Elvan Ceyhan
}
