% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{ZTrun}
\alias{ZTrun}
\title{\eqn{Z}-test for Cuzick and Edwards \eqn{T_{run}} statistic}
\usage{
ZTrun(
  dat,
  cc.lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  case.lab = NULL,
  var.sim = FALSE,
  Nvar.sim = 1000,
  ...
)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point.}

\item{cc.lab}{Case-control labels, 1 for case, 0 for control}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for Cuzick and Edwards \eqn{T_{run}} statistic}

\item{case.lab}{The label used for cases in the \code{cc.lab} (if \code{cc.lab} is not provided then the labels are converted
such that cases are 1 and controls are 0), default is \code{NULL}.}

\item{var.sim}{A logical argument (default is \code{FALSE}) to determine whether the simulation estimated variance or
the exact variance be used for the variance of \eqn{T_{run}} in its standardization.
If \code{var.sim=TRUE}, the simulation estimated variance is used for \eqn{Var[T_{run}]} (see \code{varTrun.sim}), 
otherwise the exact variance (see \code{varTrun}) is used.}

\item{Nvar.sim}{The number of simulations, i.e., the number of resamplings under the RL scheme to estimate the 
variance of \eqn{T_{run}}, used only when \code{var.sim=TRUE}.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
A \code{list} with the elements
\item{statistic}{The \eqn{Z} test statistic for the Cuzick and Edwards \eqn{T_{run}} test}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding alternative}
\item{conf.int}{Confidence interval for the Cuzick and Edwards \eqn{T_{run}} value
at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.} 
\item{estimate}{Estimate of the parameter, i.e., the Cuzick and Edwards \eqn{T_{run}} value.}
\item{null.value}{Hypothesized null value for the Cuzick and Edwards \eqn{T_{run}} value
which is \eqn{n_1 (n_1-1)/(n_0+1)} for this function.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set, \code{dat}}
}
\description{
An object of class \code{"htest"} performing a \eqn{z}-test for Cuzick and Edwards \eqn{T_{run}} test statistic 
which is based on the number of consecutive cases from the cases in the data under RL or CSR independence.

Under RL of \eqn{n_1} cases and \eqn{n_0} controls to the given locations in the study region,
\eqn{T_{run}} approximately has \eqn{N(E[T_{run}],Var[T_{run}])} distribution for large \eqn{n}.

The argument \code{cc.lab} is case-control label, 1 for case, 0 for control, if the argument \code{case.lab} is \code{NULL}, 
then \code{cc.lab} should be provided in this fashion, if \code{case.lab} is provided, the labels are converted to 0's 
and 1's accordingly. 

The logical argument var.sim (default=\code{FALSE}) is for using the simulation estimated variance or the exact 
variance for the variance of \eqn{T_{run}} in its standardization.
If \code{var.sim=TRUE}, the simulation estimated variance is used for \eqn{Var[T_{run}]} (see \code{varTrun.sim}), 
otherwise the exact variance (see \code{varTrun}) is used.
Moreover, when \code{var.sim=TRUE}, the argument \code{Nvar.sim} represents the number of resamplings 
(without replacement) in the RL scheme, with default being \code{1000}.

The function \code{varTrun} might take a very long time when data size is large (even larger than 50);
in this case, it is recommended to use \code{var.sim=TRUE} in this function.
 
See also (\insertCite{cuzick:1990;textual}{nnspat}) and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1) #try also 40, 50, 60
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)  #or try cls<-rep(0:1,c(10,10))

ZTrun(Y,cls)
ZTrun(Y,cls,method="max")
ZTrun(Y,cls,var.sim=TRUE)
ZTrun(Y,cls+1,case.lab = 2,alt="l")
ZTrun(Y,cls,conf=.9,alt="g")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ZTrun(Y,fcls,case.lab="a")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ceTrun}}, \code{\link{ZceTk}}, and \code{\link{ZTcomb}}
}
\author{
Elvan Ceyhan
}
