% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistf.pdf.R
\name{logistf.pdf}
\alias{logistf.pdf}
\title{Likehood-ratio test of two models}
\usage{
logistf.pdf(
  x,
  y,
  pos,
  firth = TRUE,
  weight,
  control,
  plcontrol,
  offset = NULL,
  b,
  beta = NULL,
  loglik = NULL,
  fit = NULL,
  old = FALSE
)
}
\arguments{
\item{x}{A model matrix returned by \code{\link[stats]{model.matrix}}}

\item{y}{The response of a model frame returned by \code{\link[stats]{model.response}}}

\item{pos}{Position of the variable (for which profile likelihood confidence
intervals should be computed) in the \code{colnames} of model matrix \code{x}}

\item{firth}{Use of Firth's penalized maximum likelihood (firth=TRUE, default)
or the standard maximum likelihood method (firth=FALSE)}

\item{weight}{An optional weighting variable for each observation}

\item{control}{Controls Newton-Raphson iteration. Default is
\code{control= logistf.control(maxstep, maxit, maxhs, lconv, gconv, xconv)}}

\item{plcontrol}{Controls Newton-Raphson iteration for the estimation of the
profile likelihood confidence intervals. Default is \code{plcontrol=
logistpl.control(maxstep, maxit, maxhs, lconv, xconv, ortho, pr)}}

\item{offset}{An optional offset variable}

\item{b}{A bound for the lower or upper limit}

\item{beta}{Regression coefficients for \code{colnames} of model matrix
\code{x} returned by \code{logistf}}

\item{loglik}{The (penalized) log-likelihood of the full models}

\item{fit}{Output of \code{logistf.fit}}

\item{old}{Corresponding to the \code{legacy} argument in \code{CLIP.confint}}
}
\description{
Please cite the original function \code{[CLIP.confint](https://CRAN.R-project.org/package=logistf/index.html])} for
publication.
}
