% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_paf.R
\name{get_paf}
\alias{get_paf}
\title{Calculate population attributable fraction using odds ratio}
\usage{
get_paf(df_or, which_or, exp_var, exp_level, df_matched)
}
\arguments{
\item{df_or}{A data frame that stores odds ratios for all exposure of
interest}

\item{which_or}{An unquoted name of the name of the column that stores odds
ratio, or its lower or upper confidence limit in \code{df_or}.}

\item{exp_var}{An unquoted name of the column that stores the name of
exposures in \code{df_or}}

\item{exp_level}{An unquoted name of the column that stores the level of the
exposure variable in \code{df_or}}

\item{df_matched}{The list of data frames used to calculate odds ratios}
}
\value{
A data frame.
}
\description{
Calculate population attributable fraction using odds ratio
}
\details{
Use odds ratio, its upper confidence limit, and its lower confidence
  limit to calculate population attributable fraction, its upper confidence
  limit, and its lower confidence limit, respectively.

  For more information, please refer to the vignette using
  \code{browseVignettes("nncc")}.
}
