% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistf.pdf.R, R/logistpl.control.r
\name{logistpl.control}
\alias{logistpl.control}
\title{Default logistpl control}
\usage{
logistpl.control(
  maxit = 100,
  maxhs = 5,
  maxstep = 5,
  lconv = 1e-05,
  xconv = 1e-05,
  ortho = FALSE,
  pr = FALSE
)

logistpl.control(
  maxit = 100,
  maxhs = 5,
  maxstep = 5,
  lconv = 1e-05,
  xconv = 1e-05,
  ortho = FALSE,
  pr = FALSE
)
}
\arguments{
\item{maxit}{The maximum number of iterations}

\item{maxhs}{The maximum number of step-halvings in one iteration. The increment of the 
beta vector within one iteration is divided by 2 if the new beta leads to a decrease 
in log likelihood.}

\item{maxstep}{Specifies the maximum step size in the beta vector within one iteration.}

\item{lconv}{Specifies the convergence criterion for the log likelihood.}

\item{xconv}{Specifies the convergence criterion for the parameter estimates.}

\item{ortho}{Requests orthogonalization of variable for which confidence intervals are computed with respect to other covariates}

\item{pr}{Request rotation of the matrix spanned by the covariates}
}
\value{
\item{maxit}{The maximum number of iterations}
   \item{maxhs}{The maximum number of step-halvings in one iteration. The increment of the 
beta vector within one iteration is divided by 2 if the new beta leads to a decrease 
in log likelihood.}
   \item{maxstep}{Specifies the maximum step size in the beta vector within one iteration.}
   \item{lconv}{Specifies the convergence criterion for the log likelihood.}
   \item{xconv}{Specifies the convergence criterion for the parameter estimates.}
   \item{ortho}{specifies if orthogonalization is requested.}
   \item{pr}{specifies if rotation is requested}
}
\description{
Sets parameters for modified Newton-Raphson iteration for finding 
profile likelihood confidence intervals in Firth's penalized likelihood logistic regression
}
\details{
\code{logistpl.control()} is used by \code{logistf} to set control parameters to default values 
when computing profile likelihood confidence intervals. 
Different values can be specified, e. g., by \code{logistf(..., control= logistf.control(maxstep=1))}.
}
\examples{
data(sexagg)
fit2<-logistf(case ~ age+oc+vic+vicl+vis+dia, data=sexagg, weights=COUNT, 
    plcontrol=logistpl.control(maxstep=1))
summary(fit2)

}
\author{
Georg Heinze
}
