% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmfgpu4R.R
\name{nmfgpu4R.init}
\alias{nmfgpu4R.init}
\title{Initializes the C++ library nmfgpu, which provides the core functionality of this package.}
\usage{
nmfgpu4R.init(quiet = F)
}
\arguments{
\item{quiet}{If true then informative messages about the found CUDA version and nmfgpu location will be suppressed.}
}
\description{
Initializes the C++ library nmfgpu, which provides the core functionality of this package.
}
\details{
As this package depends on a C++ library, there are some restrictions in terms of usage. First
this package is only compatible with x64 environments, because some CUDA libraries are not available for
x86 environments. Second you need a CUDA capable device starting with Kepler architecture, CUDA
device drivers and the CUDA toolkit with version 7.0 or higher. Lastly you need the nmfgpu library itself.
This package provides a basic service of downloading precompiled versions from github, if it is available for
your operating system and CUDA toolkit version. Otherwise you need to compile and install the library on
your own by following the instructions on \url{https://github.com/razorx89/nmfgpu}.

Even if the package downloads a precompiled version, it must not neccessarily be compatible with your system.
For example on Windows platforms you must have installed the "Microsoft Visual C++ Redistributable Packages for 
Visual Studio 2013", which can be found at \url{https://www.microsoft.com/en-us/download/details.aspx?id=40784}.
Furthermore on unix systems there could be a version mismatch with the \code{libstdc++.so} library, because the
installed compiler and the compiler which was used to build the binary could be different.

If you encounter any problems loading the nmfgpu library, then try to compile it by yourself.
}

