% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_nl.R
\name{run_nl_all}
\alias{run_nl_all}
\title{Execute all NetLogo simulations from a nl object}
\usage{
run_nl_all(nl, split = 1, cleanup.csv = TRUE, cleanup.xml = TRUE,
  cleanup.bat = TRUE, silent = TRUE)
}
\arguments{
\item{nl}{nl object}

\item{split}{number of parts the job should be split into}

\item{cleanup.csv}{TRUE/FALSE, if TRUE temporary created csv output files will be deleted after gathering results.}

\item{cleanup.xml}{TRUE/FALSE, if TRUE temporary created xml output files will be deleted after gathering results.}

\item{cleanup.bat}{TRUE/FALSE, if TRUE temporary created bat/sh output files will be deleted after gathering results.}

\item{silent}{TRUE/FALSE, if FALSE prints the current seed and siminputrow after successful execution of a simulation (only for sequential execution).}
}
\value{
tibble with simulation output results
}
\description{
Execute all NetLogo simulations from a nl object with a defined experiment and simdesign
}
\details{
run_nl_all executes all simulations of the specified NetLogo model within the provided nl object.
The function loops over all random seeds and all rows of the siminput table of the simdesign of nl.
The loops are created by calling \link[furrr]{future_map_dfr}, which allows running the function either locally or on remote HPC machines.
The logical cleanup variables can be set to FALSE to preserve temporary generated output files (e.g. for debugging).
cleanup.csv deletes/keeps the temporary generated model output files from each run.
cleanup.xml deletes/keeps the temporary generated experiment xml files from each run.
cleanup.bat deletes/keeps the temporary generated batch/sh commandline files from each run.

When using run_nl_all in a parallelized environment (e.g. by setting up a future plan using the future package),
the outer loop of this function (random seeds) creates jobs that are distributed to available cores of the current machine.
The inner loop (siminputrows) distributes simulation tasks to these cores.
However, it might be advantageous to split up large jobs into smaller jobs for example to reduce the total runtime of each job.
This can be done using the split parameter. If split is > 1 the siminput matrix is split into smaller parts.
Jobs are created for each combination of part and random seed.
If the split parameter is set such that the siminput matrix can not be splitted into equal parts, the procedure will stop and throw an error message.
}
\examples{
\dontrun{

# Load nl object from test data:
nl <- nl_lhs

# Execute all simulations from an nl object with properly attached simdesign.
results <- run_nl_all(nl)

# Run in parallel on local machine:
library(future)
plan(multisession)
results \%<-\% run_nl_all(nl)

}
}
