% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_nls.R
\name{simulate_nls}
\alias{simulate_nls}
\title{Simulate fitted values from an object of class \code{\link[stats]{nls}}}
\usage{
simulate_nls(
  object,
  nsim = 1,
  psim = 1,
  resid.type = c("resample", "normal", "wild"),
  value = c("matrix", "data.frame"),
  ...
)
}
\arguments{
\item{object}{object of class \code{\link[stats]{nls}}}

\item{nsim}{number of simulations to perform}

\item{psim}{parameter simulation level, 0: for fitted values, 1: for simulation from 
fixed parameters (assuming a fixed vcov matrix), 2: simulation from sampling
both from the parameters and the residuals, 3: for simulation considering the 
uncertainty in the residual standard error only (sigma) and fixing the
parameter estimates at their original value; this will result in simulations 
similar to the observed values.}

\item{resid.type}{either \dQuote{resample}, \dQuote{normal} or \dQuote{wild}.}

\item{value}{either \sQuote{matrix} or \sQuote{data.frame}}

\item{...}{additional arguments (it is possible to supply a newdata this way)}
}
\value{
It returns a vector with simulated values with length equal to the number of rows 
in the original data
}
\description{
Simulate values from an object of class nls.
}
\details{
This function is based on \code{\link[nlme]{predict.gnls}} function

It uses function \code{\link[MASS]{mvrnorm}} to generate new values for the coefficients
of the model using the Variance-Covariance matrix \code{\link{vcov}}. This variance-covariance matrix 
refers to the one for the parameters 'beta', not the one for the residuals.
}
\examples{
\donttest{
require(nlme)
data(barley, package = "nlraa")

fit <- nls(yield ~ SSlinp(NF, a, b, xs), data = barley)

sim <- simulate_nls(fit, nsim = 100)
}
}
\seealso{
\code{\link[nlme]{predict.gnls}}
}
