% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSnrh.R
\name{SSnrh}
\alias{SSnrh}
\alias{nrh}
\title{self start for non-rectangualr hyperbola (photosynthesis)}
\usage{
nrh(x, asym, phi, theta, rd)

SSnrh(x, asym, phi, theta, rd)
}
\arguments{
\item{x}{input vector (x) which is normally light intensity (PPFD, Photosynthetic Photon Flux Density).}

\item{asym}{asymptotic value for photosynthesis}

\item{phi}{quantum efficiency (mol CO2 per mol of photons) or initial slope of the light response}

\item{theta}{curvature parameter for smooth transition between limitations}

\item{rd}{dark respiration or value of CO2 uptake at zero light levels}
}
\value{
a numeric vector of the same length as x (time) containing parameter estimates for equation specified

nrh: vector of the same length as x (time) using the non-rectangular hyperbola
}
\description{
Self starter for Non-rectangual Hyperbola with parameters: asymptote, quantum efficiency, curvature and dark respiration
}
\details{
This function is described in Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506).
}
\examples{
\donttest{
require(ggplot2)
set.seed(1234)
x <- seq(0, 2000, 100)
y <- nrh(x, 35, 0.04, 0.83, 2) + rnorm(length(x), 0, 0.5)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSnrh(x, asym, phi, theta, rd), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
x <- seq(0, 2000)
y <- nrh(x, 30, 0.04, 0.85, 2)
plot(x, y)
}
