% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_warfarin.R
\docType{data}
\name{warfarin}
\alias{warfarin}
\title{Warfarin PK/PD data}
\format{
A data frame with 519 rows and 9 columns

\describe{
\item{id}{Patient identifier (n=32)}
\item{time}{Time (h)}
\item{amt}{Total drug administered (mg)}
\item{dv}{Warfarin concentrations (mg/L) or PCA measurement}
\item{dvid}{Dependent identifier Information (cp: Dose or PK, pca: PCA, factor)}
\item{evid}{Event identifier}
\item{wt}{Weight (kg)}
\item{age}{Age (yr)}
\item{sex}{Gender (male or female, factor)}
}
}
\source{
Funaki T, Holford N, Fujita S (2018). Population PKPD
analysis using nlmixr2 and NONMEM. PAGJA 2018
}
\usage{
warfarin
}
\description{
Warfarin PK/PD data
}
\references{
O'Reilly RA, Aggeler PM, Leong LS. Studies of the coumarin
anticoagulant drugs: The pharmacodynamics of warfarin in man.
Journal of Clinical Investigation 1963; 42(10): 1542-1551

O'Reilly RA, Aggeler PM. Studies on coumarin anticoagulant drugs
Initiation of warfarin therapy without a loading dose. Circulation
1968; 38: 169-177.
}
\seealso{
Other nlmixr2 datasets: 
\code{\link{Bolus_1CPTMM}},
\code{\link{Bolus_1CPT}},
\code{\link{Bolus_2CPTMM}},
\code{\link{Bolus_2CPT}},
\code{\link{Infusion_1CPTMM}},
\code{\link{Infusion_1CPT}},
\code{\link{Infusion_2CPTMM}},
\code{\link{Infusion_2CPT}},
\code{\link{Oral_1CPTMM}},
\code{\link{Oral_1CPT}},
\code{\link{Oral_2CPTMM}},
\code{\link{Oral_2CPT}},
\code{\link{Wang2007}},
\code{\link{mavoglurant}},
\code{\link{nimoData}},
\code{\link{pheno_sd}},
\code{\link{rats}},
\code{\link{theo_md}},
\code{\link{theo_sd}},
\code{\link{wbcSim}}
}
\concept{nlmixr2 datasets}
\keyword{datasets}
