% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmph3UnEb/file63ef4546bacc
\name{asRow}
\alias{asCol}
\alias{asRow}
\title{Turn a numeric vector into a single-row or single-column matrix}
\usage{
asRow(x)

asCol(x)
}
\arguments{
\item{x}{Numeric to be turned into a single row or column matrix}
}
\description{
Turns a numeric vector into a matrix that has 1 row or 1 column.  Part of NIMBLE language.
}
\details{
In the NIMBLE language, some automatic determination of how to turn vectors into single-row or single-column matrices is done.
For example, in \code{A \%*\% x}, where A is a matrix and x a vector, x will be turned into a single-column matrix unless
it is known at compile time that A is a single column, in which case x will be turned into a single-row matrix.
However, if it is desired that x be turned into a single row but A cannot be determined at compile time to be a single column,
then one can use \code{A \%*\% asRow(x)} to force this conversion.
}
\author{
Perry de Valpine
}

