% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPCRI.R
\name{NPCRI}
\alias{NPCRI}
\title{NPCRI - Normalized Pigment Chlorophyll Ratio Index}
\usage{
NPCRI(B, R)
}
\arguments{
\item{B}{A raster layer object with the reflectance values for the Blue band.}

\item{R}{A raster layer object with the reflectance values for the Red band.}
}
\value{
NPCRI - Normalized Pigment Chlorophyll Ratio Index.
}
\description{
NPCRI is an index that is associated with the chlorophyll content and can find applications in precission agriculture. Using the red and blue spectral bands, NPCRI captures the information needed to quantify chlorophyll and Nitrogen.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
bands <- stack(list.files(path_files,".tif", full.names=TRUE))
x <- ref_oli(bands, sun.elev= 67.97)
NPCRI(x[[2]], x[[4]])

}
\references{
\url{https://www.geo.university/pages/spectral-indices-with-multispectral-satellite-data}.
}
