% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histograms_env.R
\name{histograms_env}
\alias{histograms_env}
\title{Histograms of environmental conditions in M and for occurrences}
\usage{
histograms_env(M_folder, M_format, occ_folder, longitude, latitude,
  var_folder, var_format, CL_lines = c(95, 99), col = NULL,
  round = FALSE, round_names = NULL, multiplication_factor = 1,
  save_ranges = FALSE, output_directory, overwrite = FALSE)
}
\arguments{
\item{M_folder}{(character) name of the folder containing files representing
the accessible area (M) for all species to be analyzed. See details.}

\item{M_format}{format of files representing the accessible area (M) for the
species. Names of M files must match the ones for occurrence files in
\code{occ_folder}. Format options are: "shp", "gpkg", or any of the options
in \code{\link[raster]{writeFormats}} (e.g., "GTiff").}

\item{occ_folder}{(character) name of the folder containing csv files of
occurrence data for all species. Names of csv files must match the ones of M
files in \code{M_folder}.}

\item{longitude}{(character) name of the column in occurrence files containing
values of longitude.}

\item{latitude}{(character) name of the column in occurrence files containing
values of latitude.}

\item{var_folder}{(character) name of the folder containing layers to
represent environmental variables.}

\item{var_format}{format of layers to represent environmental variables. See
options in \code{\link[raster]{writeFormats}} (e.g., "GTiff").}

\item{CL_lines}{(numeric) confidence limits of environmental values in M to
be plotted as lines in the histograms. See details. Default = c(95, 99).}

\item{col}{colors for lines representing confidence limits. If NULL, colors
are selected from a gray palette. Default = NULL.}

\item{round}{(logical) whether or not to round values of one or more
variables after multiplying them times the value in \code{multiplication_factor}.
Default = FALSE. See details.}

\item{round_names}{(character) names of the variables to be rounded.
Default = NULL. If \code{round} = TRUE, names must be defined.}

\item{multiplication_factor}{(numeric) value to be used to multiply the
variables defined in \code{round_names}. Default = 1.}

\item{save_ranges}{(logical) whether or not to save the values identified as
ranges considering the whole set of values and confidence limits defined in
\code{CL_lines}. Default = FALSE.}

\item{output_directory}{(character) name of the folder in which results will be
written.}

\item{overwrite}{(logical) whether or not to overwrite existing results in
\code{output_directory}. Default = FALSE.}
}
\value{
A list of data.frames containing intervals of environmental values in species
occurrences and accessible areas (M), as well as values corresponding to the
confidence limits defined in \code{CL_lines}. A folder named as
in \code{output_directory} containing all resulting PDF files (one per
variable) with histograms for all species. Files (csv) of ranges found during
the analyses will be also written in \code{output_directory} if
\code{save_ranges} is set as TRUE.
}
\description{
histograms_env creates PDF files with histogram plots of
environmental conditions in M, lines for the confidence limits of values in
M, and the location of values in occurrence records. This is done using data
read directly from a local directory, and can be applied to various species
and multiple variables.
}
\details{
Coordinates in csv files in \code{occ_folder}, SpatialPolygons*-like files in
\code{M_folder}, and raster layers in \code{var_folder} must coincide in the
geographic projection in which they are represented. WGS84 with no planar
projection is recommended.

Accessible area (M) is understood as the geographic area that has been
accessible for a species for relevant periods of time. Defining M is usually
a hard task, but also a very important one, because it allows identifying
uncertainties about the ability of a species to maintain populations under
certain environmental conditions. For further details on this topic, see
Barve et al. (2011) in \url{https://doi.org/10.1016/j.ecolmodel.2011.02.011}.

Rounding variables may be useful when multiple variables are considered and
the values of some or all of them are too small (e.g., when using principal
components). To round specific variables arguments \code{round},
\code{round_names}, and \code{multiplication_factor}, must be used accordingly.
}
\examples{
# example of how to define arguments, check argument descriptions above
\donttest{
hists <- histograms_env(M_folder = "Folder_with_Ms", M_format = "shp",
                        occ_folder = "Folder_with_occs", longitude = "lon_column",
                        latitude = "lat_column", var_folder = "Folder_with_vars",
                        var_format = "GTiff",
                        output_directory = file.path(tempdir(), "Hist_env"))
}
}
