% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hydro.R
\name{get_gagesII}
\alias{get_gagesII}
\title{Find gagesII Features}
\usage{
get_gagesII(AOI = NULL, id = NULL, t_srs = NULL, buffer = 0.5, basin = FALSE)
}
\arguments{
\item{AOI}{sf (MULTI)POINT or (MULTI)POLYGON. An 'area of interest' can
be provided as either a location (sf POINT) or area (sf POLYGON)
in any Spatial Reference System.}

\item{id}{character NWIS Gage ID(s)}

\item{t_srs}{character (PROJ string or EPSG code) or numeric (EPSG code).
A user specified - target -Spatial Reference System (SRS/CRS) for returned objects.
Will default to the CRS of the input AOI if provided, and to 4326 for ID requests.}

\item{buffer}{numeric. The amount (in meters) to buffer a POINT AOI by for an
extended search. Default = 0.5}

\item{basin}{logical should the gagesII basin also be returned? If True,
return value will be a list with "site" and "basin" elements.}
}
\value{
a simple features (sf) object
}
\description{
Subsets the gagesII dataset by location (POINT),
area (POLYGON), or set of IDs. See <doi:10.5066/P96CPHOT> for documentation of source data.
}
\details{
The returned object(s) will have the same
Spatial Reference System (SRS) as the input AOI. If a individual or set of
IDs are used to query, then the default server CRS of EPSG:4326 is
preserved. In all cases, a user-defined SRS can be passed to \code{t_srs}
which will override all previous SRS (either input or default).
All buffer and distance operations are handled internally using an
EPSG:5070 Albers Equal Area projection
}
