% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{fusions_filter}
\alias{fusions_filter}
\title{Fusions handler_data filter that can be used to prepare the input data for downstream analysis}
\usage{
fusions_filter(input_data, input_type = "common",
  config_file = system.file("extdata", "config/filter.toml", package =
  "ngstk"), config_list = NULL, handler_confg_file = system.file("extdata",
  "config/handler.toml", package = "ngstk"),
  mhandler_confg_file = system.file("extdata", "config/mhandler.toml", package
  = "ngstk"), handler_funs = NULL, mhandler_funs = NULL,
  handler_extra_params = NULL, mhandler_extra_params = NULL, outfn = NULL)
}
\arguments{
\item{input_data}{A data frame containing the fusions cols (gene5, gene3, fusion_type)}

\item{input_type}{Fusion filter type}

\item{config_file}{ngstk filter configuration file path, default is 
system.file('extdata', 'config/filter.toml', package = 'ngstk')}

\item{config_list}{ngstk filter configuration, default is NULL and 
read from config_file}

\item{handler_confg_file}{ngstk handler configuration file path, default is 
system.file('extdata', 'config/handler.toml', package = 'ngstk')}

\item{mhandler_confg_file}{ngstk handler configuration file path, default is 
system.file('extdata', 'config/mhandler.toml', package = 'ngstk')}

\item{handler_funs}{handler function for single colnum, 
default is NULL and get value from config_file}

\item{mhandler_funs}{handler function for mulitple colnums,
#' default is NULL and get value from config_file}

\item{handler_extra_params}{Extra parameters pass to handler}

\item{mhandler_extra_params}{Extra parameters pass to mhandler
system.file('extdata', 'config/filter.toml', package = 'ngstk')}

\item{outfn}{Default is NULL and not output the result to file}
}
\value{
A data frame
}
\description{
Fusions handler_data filter that can be used to prepare the input data for downstream analysis
}
\examples{
demo_file <- system.file('extdata', 
'demo/proteinpaint/fusions2pp_fusioncatcher.txt', package = 'ngstk')
input_data <- read.table(demo_file, sep = '\\t', header = TRUE, stringsAsFactors = FALSE)
result <- fusions_filter(input_data)
}
