% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge_table_files}
\alias{merge_table_files}
\title{Util function to merge multiple table files.}
\usage{
merge_table_files(input_files = NULL, files_dir = NULL,
  pattern = ".*.txt", outfn = NULL, add.filename = TRUE,
  read_fun = "read.table", read_params_file = "file",
  read_params = list(sep = "\\t", header = TRUE), write_fun = "write.table",
  write_params_x = "x", write_params_file = "file",
  write_params = list(sep = "\\t", row.names = FALSE),
  op = list(stringsAsFactors = FALSE))
}
\arguments{
\item{input_files}{Basename of files that need to be merged, default is NULL 
and use the regular expression pattern to select files}

\item{files_dir}{Directory name of input files}

\item{pattern}{Use regular expression to select files in files_dir}

\item{outfn}{Output file path, default is NULL and return the data.frame object}

\item{add.filename}{Wheather to add the merged filename, default is TRUE}

\item{read_fun}{Function to read data, default is read.table}

\item{read_params_file}{Parameter name of input file in read_fun}

\item{read_params}{Other parameters pass to read_fun}

\item{write_fun}{Function to read data, default is read.table}

\item{write_params_x}{Parameter name of output object in read.fun}

\item{write_params_file}{Parameter name of input file in read.fun}

\item{write_params}{Other parameters pass to write_fun}

\item{op, }{Extra option that only take effect in merge process}
}
\description{
Util function to merge multiple table files.
}
\examples{
a <- data.frame(col1=1:6, col2=2:7)
b <- data.frame(col1=6:11, col2=1:6)
file_a <- paste0(tempfile(), '_abcd')
file_b <- paste0(tempfile(), '_abcd')
write.table(a, file_a, sep = '\\t', row.names = FALSE)
write.table(b, file_b, sep = '\\t', row.names = FALSE)
input_files <- c(file_a, file_b)
x1 <- merge_table_files(input_files = input_files)
x2 <- merge_table_files(files_dir = tempdir(), pattern = '.*_abcd$')
outfn = tempfile()
}
