% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_ffverse.R
\name{load_ff_opportunity}
\alias{load_ff_opportunity}
\title{Load Expected Fantasy Points}
\usage{
load_ff_opportunity(
  seasons = most_recent_season(),
  stat_type = c("weekly", "pbp_pass", "pbp_rush"),
  model_version = c("latest", "v1.0.0")
)
}
\arguments{
\item{seasons}{a numeric vector of seasons to return, defaults to most recent season. If set to \code{TRUE}, returns all available data.}

\item{stat_type}{one of \code{"weekly"}, \code{"pbp_pass"}, \code{"pbp_rush"}}

\item{model_version}{one of \code{"latest"} or \code{"v1.0.0"}}
}
\value{
Precomputed expected fantasy points data from the ffopportunity automated releases.
}
\description{
This function downloads precomputed expected points data from \href{https://ffopportunity.ffverse.com}{{ffopportunity}} automated releases.
}
\examples{
\donttest{
  try({ # prevents cran errors
  load_ff_opportunity()
  load_ff_opportunity(seasons = 2021, stat_type = "pbp_pass", model_version = "v1.0.0")
  })
}

}
\seealso{
\url{https://ffopportunity.ffverse.com} for more on the package, data, and modelling

\url{https://nflreadr.nflverse.com/articles/dictionary_ff_opportunity.html} for the web data dictionary

\code{\link{dictionary_ff_opportunity}} for the data dictionary bundled as a package data frame

Issues with this data should be filed here: \url{https://github.com/ffverse/ffopportunity}
}
