% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{barplot}
\alias{barplot}
\alias{barplot,CompositionMatrix-method}
\title{Barplot of Compositional Data}
\usage{
\S4method{barplot}{CompositionMatrix}(
  height,
  ...,
  order = NULL,
  decreasing = FALSE,
  groups = get_groups(height),
  horiz = TRUE,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  col = grDevices::hcl.colors(ncol(height), "viridis"),
  legend = list()
)
}
\arguments{
\item{height}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Further parameters to be passed to \code{\link[graphics:barplot]{graphics::barplot()}}.}

\item{order}{An \code{\link{integer}} vector giving the index of the column to be used
for the ordering of the data.}

\item{decreasing}{A \code{\link{logical}} scalar: should the sort order be increasing
or decreasing?}

\item{groups}{A \code{\link{factor}} in the sense that \code{\link[=as.factor]{as.factor(groups)}}
defines the grouping. If set, a matrix of panels defined by \code{groups} will be
drawn.}

\item{horiz}{A \code{\link{logical}} scalar. If \code{FALSE}, the bars are drawn vertically
with the first bar to the left. If \code{TRUE} (the default), the bars are drawn
horizontally with the first at the bottom.}

\item{xlab, ylab}{A \code{\link{character}} vector giving the x and y axis labels.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{col}{A vector of colors for the bar components.}

\item{legend}{A \code{\link{list}} of additional arguments to be passed to
\code{\link[graphics:legend]{graphics::legend()}}; names of the list are used as argument names.
If \code{NULL}, no legend is displayed.}
}
\value{
\code{barplot()} is called for its side-effects: is results in a graphic being
displayed (invisibly return \code{height}).
}
\description{
Displays a compositional bar chart.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Bar plot
barplot(coda, order = 2)

## Data from Day et al. 2011
data("kommos", package = "folio") # Coerce to compositional data
kommos <- remove_NA(kommos, margin = 1) # Remove cases with missing values
coda <- as_composition(kommos, groups = 1) # Use ceramic types for grouping

barplot(coda, order = 1)
barplot(coda, order = 1, horiz = FALSE)
}
\seealso{
Other plot methods: 
\code{\link{as_graph}()},
\code{\link{hist}()},
\code{\link{plot_logratio}},
\code{\link{plot}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
