% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nvd-class.R
\name{sample2_sbm}
\alias{sample2_sbm}
\title{Two-Sample Stochastic Block Model Generator}
\usage{
sample2_sbm(n, nv, p1, b1, p2 = p1, b2 = b1, seed = NULL)
}
\arguments{
\item{n}{Integer scalar giving the sample size.}

\item{nv}{Integer scalar giving the number of vertices of the generated
networks, common to all networks in both samples.}

\item{p1}{The matrix giving the Bernoulli rates for the 1st sample. This is a
KxK matrix, where K is the number of groups. The probability of creating an
edge between vertices from groups i and j is given by element (i,j). For
undirected graphs, this matrix must be symmetric.}

\item{b1}{Numeric vector giving the number of vertices in each group for the
first sample. The sum of the vector must match the number of vertices.}

\item{p2}{The matrix giving the Bernoulli rates for the 2nd sample (default:
same as 1st sample). This is a KxK matrix, where K is the number of groups.
The probability of creating an edge between vertices from groups i and j is
given by element (i,j). For undirected graphs, this matrix must be
symmetric.}

\item{b2}{Numeric vector giving the number of vertices in each group for the
second sample (default: same as 1st sample). The sum of the vector must
match the number of vertices.}

\item{seed}{The seed for the random number generator (default: \code{NULL}).}
}
\value{
A length-2 list containing the two samples stored as
\code{\link{nvd}} objects.
}
\description{
This function generates two samples of networks according to the stochastic
block model (SBM). This is essentially a wrapper around
\code{\link[igraph]{sample_sbm}} which allows to sample a single network from
the SBM.
}
\examples{
n <- 10
p1 <- matrix(
  data = c(0.1, 0.4, 0.1, 0.4,
           0.4, 0.4, 0.1, 0.4,
           0.1, 0.1, 0.4, 0.4,
           0.4, 0.4, 0.4, 0.4),
  nrow = 4,
  ncol = 4,
  byrow = TRUE
)
p2 <- matrix(
  data = c(0.1, 0.4, 0.4, 0.4,
           0.4, 0.4, 0.4, 0.4,
           0.4, 0.4, 0.1, 0.1,
           0.4, 0.4, 0.1, 0.4),
  nrow = 4,
  ncol = 4,
  byrow = TRUE
)
sim <- sample2_sbm(n, 68, p1, c(17, 17, 17, 17), p2, seed = 1234)
}
