% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainVector.R
\docType{methods}
\name{writeVector}
\alias{writeVector}
\alias{writeVector,BrainVector,character,character,missing-method}
\alias{writeVector,BrainVector,character,missing,character,ANY-method}
\alias{writeVector,BrainVector,character,missing,character-method}
\alias{writeVector,BrainVector,character,missing,missing-method}
\title{Generic function to write a 4D image vector to disk}
\usage{
writeVector(x, fileName, format, dataType)

\S4method{writeVector}{BrainVector,character,missing,missing}(x, fileName)

\S4method{writeVector}{BrainVector,character,character,missing}(x, fileName,
  format)

\S4method{writeVector}{BrainVector,character,missing,character}(x, fileName,
  dataType)
}
\arguments{
\item{x}{an image object, typically a \code{BrainVector} instance.}

\item{fileName}{output file name.}

\item{format}{file format string. Since "NIFTI" is the only currently supported format, this parameter can be safely ignored and omitted.}

\item{dataType}{the numeric data type. If specified should be a \code{character} vector of: "BINARY", "UBYTE", "SHORT", "INT", "FLOAT", "DOUBLE".
Otherwise output format will be inferred from R the datatype of the image.}
}
\description{
Generic function to write a 4D image vector to disk
}
\examples{
bvec <- BrainVector(array(0, c(10,10,10,10)), BrainSpace(c(10,10,10,10), c(1,1,1)))
\dontrun{
writeVector(bvec, "out.nii")
writeVector(bvec, "out.nii.gz")
}
}

